/*
 * Decompiled with CFR 0.152.
 */
package jla.embed.org.jcodec.containers.mp4;

import jla.embed.org.jcodec.containers.mp4.AudioBoxes;
import jla.embed.org.jcodec.containers.mp4.Boxes;
import jla.embed.org.jcodec.containers.mp4.DataBoxes;
import jla.embed.org.jcodec.containers.mp4.DefaultBoxes;
import jla.embed.org.jcodec.containers.mp4.IBoxFactory;
import jla.embed.org.jcodec.containers.mp4.SampleBoxes;
import jla.embed.org.jcodec.containers.mp4.TimecodeBoxes;
import jla.embed.org.jcodec.containers.mp4.VideoBoxes;
import jla.embed.org.jcodec.containers.mp4.WaveExtBoxes;
import jla.embed.org.jcodec.containers.mp4.boxes.AudioSampleEntry;
import jla.embed.org.jcodec.containers.mp4.boxes.Box;
import jla.embed.org.jcodec.containers.mp4.boxes.DataRefBox;
import jla.embed.org.jcodec.containers.mp4.boxes.Header;
import jla.embed.org.jcodec.containers.mp4.boxes.NodeBox;
import jla.embed.org.jcodec.containers.mp4.boxes.SampleDescriptionBox;
import jla.embed.org.jcodec.containers.mp4.boxes.TimecodeSampleEntry;
import jla.embed.org.jcodec.containers.mp4.boxes.VideoSampleEntry;
import jla.embed.org.jcodec.containers.mp4.boxes.WaveExtension;
import jla.embed.org.jcodec.platform.Platform;

public class BoxFactory
implements IBoxFactory {
    private static IBoxFactory instance = new BoxFactory(new DefaultBoxes());
    private static IBoxFactory audio = new BoxFactory(new AudioBoxes());
    private static IBoxFactory data = new BoxFactory(new DataBoxes());
    private static IBoxFactory sample = new BoxFactory(new SampleBoxes());
    private static IBoxFactory timecode = new BoxFactory(new TimecodeBoxes());
    private static IBoxFactory video = new BoxFactory(new VideoBoxes());
    private static IBoxFactory waveext = new BoxFactory(new WaveExtBoxes());
    private Boxes boxes;

    public static IBoxFactory getDefault() {
        return instance;
    }

    public BoxFactory(Boxes boxes) {
        this.boxes = boxes;
    }

    @Override
    public Box newBox(Header header) {
        Class<? extends Box> claz = this.boxes.toClass(header.getFourcc());
        if (claz == null) {
            return new Box.LeafBox(header);
        }
        Box box = Platform.newInstance(claz, new Object[]{header});
        if (box instanceof NodeBox) {
            NodeBox nodebox = (NodeBox)box;
            if (nodebox instanceof SampleDescriptionBox) {
                nodebox.setFactory(sample);
            } else if (nodebox instanceof VideoSampleEntry) {
                nodebox.setFactory(video);
            } else if (nodebox instanceof AudioSampleEntry) {
                nodebox.setFactory(audio);
            } else if (nodebox instanceof TimecodeSampleEntry) {
                nodebox.setFactory(timecode);
            } else if (nodebox instanceof DataRefBox) {
                nodebox.setFactory(data);
            } else if (nodebox instanceof WaveExtension) {
                nodebox.setFactory(waveext);
            } else {
                nodebox.setFactory(this);
            }
        }
        return box;
    }
}

