/*
 * Decompiled with CFR 0.152.
 */
package nl.elec332.util.javarecorder;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import nl.elec332.util.implementationmanager.ImplementationManager;
import nl.elec332.util.javarecorder.api.IRecorder;
import nl.elec332.util.javarecorder.modifiers.DecimatedRecorder;
import nl.elec332.util.javarecorder.modifiers.ThreadedRecorder;

public class JavaRecorder {
    private static final IRecorder<?> FASTEST_RECORDER = (IRecorder)ImplementationManager.loadService(IRecorder.class);
    private static final Collection<IRecorder<?>> ALL_RECORDERS;

    public static IRecorder<?> getFastestRecorder() {
        return FASTEST_RECORDER;
    }

    public static Collection<IRecorder<?>> getAllRecorders() {
        return ALL_RECORDERS;
    }

    @SafeVarargs
    public static <T> IRecorder<T> modifyRecorder(IRecorder<T> recorder, Function<IRecorder<T>, IRecorder<T>> ... modifiers) {
        IRecorder<T> ret = recorder;
        for (Function<IRecorder<IRecorder<T>>, IRecorder<IRecorder<T>>> function : modifiers) {
            ret = function.apply(ret);
        }
        return ret;
    }

    @SafeVarargs
    public static <T> UnaryOperator<IRecorder<T>> createModifier(Function<IRecorder<T>, IRecorder<T>> ... modifiers) {
        Function<Object, Object> ret = UnaryOperator.identity();
        for (Function<IRecorder<T>, IRecorder<T>> func : modifiers) {
            ret = ret.andThen(func);
        }
        return ret::apply;
    }

    public static <T> IRecorder<T> threaded(IRecorder<T> recorder) {
        return new ThreadedRecorder<T>(recorder);
    }

    public static <T> IRecorder<T> decimated(IRecorder<T> recorder) {
        return JavaRecorder.decimated(recorder, 30);
    }

    public static <T> IRecorder<T> decimated(IRecorder<T> recorder, int maxFps) {
        return new DecimatedRecorder<T>(recorder, maxFps);
    }

    static {
        HashSet recorder = new HashSet();
        ImplementationManager.loadServices(IRecorder.class).forEach(recorder::add);
        ALL_RECORDERS = Collections.unmodifiableCollection(recorder);
    }
}

