/*
 * Decompiled with CFR 0.152.
 */
package nl.elec332.util.javarecorder.api;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.function.Supplier;
import nl.elec332.util.implementationmanager.api.IExtensionImplementation;
import nl.elec332.util.implementationmanager.api.ImplementationType;

public interface IRecorder<T>
extends IExtensionImplementation {
    public ImplementationType getImplementationType();

    public void startRecorder(int var1, int var2, int var3, File var4);

    public void stopRecorder();

    public boolean isRecording();

    public void encodeFrame(T var1);

    default public void encodeFrame(Supplier<T> frame) {
        if (frame == null) {
            return;
        }
        this.encodeFrame(frame.get());
    }

    default public void encodeFrame(BufferedImage frame) {
        this.encodeFrame(this.convertFrame(frame));
    }

    public Supplier<T> convertFrame(BufferedImage var1);

    public static BufferedImage reformatImage(BufferedImage sourceImage, int targetType, int width, int height) {
        int newWidth = 0;
        int newHeight = 0;
        while (newHeight + sourceImage.getHeight() <= height) {
            newHeight += sourceImage.getHeight();
        }
        while (newWidth + sourceImage.getWidth() <= width) {
            newWidth += sourceImage.getWidth();
        }
        if (newWidth == 0) {
            newWidth = width;
        }
        if (newHeight == 0) {
            newHeight = height;
        }
        if (sourceImage.getType() == targetType && newHeight == sourceImage.getHeight() && newWidth == sourceImage.getWidth()) {
            return sourceImage;
        }
        BufferedImage image = new BufferedImage(width, height, targetType);
        image.getGraphics().drawImage(sourceImage, 0, 0, newWidth, newHeight, null);
        return image;
    }
}

