/*
 * Decompiled with CFR 0.152.
 */
package nl.elec332.util.javarecorder.impl;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import jla.embed.org.jcodec.api.SequenceEncoder;
import jla.embed.org.jcodec.common.Codec;
import jla.embed.org.jcodec.common.Format;
import jla.embed.org.jcodec.common.io.NIOUtils;
import jla.embed.org.jcodec.common.io.SeekableByteChannel;
import jla.embed.org.jcodec.common.model.ColorSpace;
import jla.embed.org.jcodec.common.model.Picture;
import jla.embed.org.jcodec.common.model.Rational;
import nl.elec332.util.implementationmanager.api.ImplementationType;
import nl.elec332.util.javarecorder.api.IRecorder;

public class JCodecRecorder
implements IRecorder<Picture> {
    protected final ReentrantLock lock = new ReentrantLock();
    protected SeekableByteChannel recOut = null;
    protected SequenceEncoder recorder = null;
    protected int width;
    protected int height;

    @Override
    public ImplementationType getImplementationType() {
        return ImplementationType.JAVA_DEFAULT;
    }

    @Override
    public void startRecorder(int fps, int width, int height, File file) {
        if (this.recOut != null) {
            throw new IllegalStateException();
        }
        this.lock.lock();
        try {
            this.recOut = NIOUtils.writableChannel(file);
            this.width = width;
            this.height = height;
            this.recorder = new SequenceEncoder(this.recOut, Rational.R(fps, 1), Format.MOV, Codec.H264, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.lock.unlock();
    }

    @Override
    public void stopRecorder() {
        if (this.recOut == null) {
            throw new IllegalStateException();
        }
        this.lock.lock();
        try {
            this.recorder.finish();
            this.recorder = null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            NIOUtils.closeQuietly(this.recOut);
            this.recOut = null;
        }
        this.lock.unlock();
    }

    @Override
    public void encodeFrame(Picture frame) {
        if (this.recorder != null) {
            this.lock.lock();
            try {
                this.recorder.encodeNativeFrame(frame);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.lock.unlock();
        }
    }

    @Override
    public boolean isRecording() {
        return this.recorder != null;
    }

    @Override
    public Supplier<Picture> convertFrame(BufferedImage image) {
        return () -> JCodecRecorder.fromBufferedImageRGB(IRecorder.reformatImage(image, 1, this.width, this.height));
    }

    public static Picture fromBufferedImageRGB(BufferedImage src) {
        Picture dst = Picture.create(src.getWidth(), src.getHeight(), ColorSpace.RGB);
        JCodecRecorder.fromBufferedImage(src, dst);
        return dst;
    }

    public static void fromBufferedImage(BufferedImage src, Picture dst) {
        byte[] dstData = dst.getPlaneData(0);
        int off = 0;
        for (int i = 0; i < src.getHeight(); ++i) {
            for (int j = 0; j < src.getWidth(); ++j) {
                int rgb1 = src.getRGB(j, i);
                dstData[off++] = (byte)((rgb1 >> 16 & 0xFF) - 128);
                dstData[off++] = (byte)((rgb1 >> 8 & 0xFF) - 128);
                dstData[off++] = (byte)((rgb1 & 0xFF) - 128);
            }
        }
    }
}

