/*
 * Decompiled with CFR 0.152.
 */
package nl.elec332.util.javarecorder.modifiers;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.function.Supplier;
import nl.elec332.util.implementationmanager.api.ImplementationType;
import nl.elec332.util.javarecorder.AbstractDelegatedRecorder;
import nl.elec332.util.javarecorder.api.IRecorder;

public class DecimatedRecorder<T>
extends AbstractDelegatedRecorder<T> {
    private final int maxFps;
    private int decimation;
    private int counter;

    public DecimatedRecorder(IRecorder<T> parent, int maxFps) {
        super(parent);
        this.maxFps = maxFps;
        this.counter = 0;
    }

    @Override
    public ImplementationType getImplementationType() {
        return this.parent.getImplementationType();
    }

    @Override
    public int getImplementationSpeed() {
        return this.parent.getImplementationSpeed();
    }

    @Override
    public void startRecorder(int fps, int width, int height, File file) {
        int usedFps = Math.min(fps, this.maxFps);
        this.decimation = Math.floorDiv(fps, usedFps);
        this.parent.startRecorder(usedFps, width, height, file);
    }

    @Override
    public void stopRecorder() {
        this.parent.stopRecorder();
    }

    @Override
    public boolean isRecording() {
        return this.parent.isRecording();
    }

    @Override
    public void encodeFrame(T frame) {
        if (this.decimation <= 1) {
            this.parent.encodeFrame(frame);
            return;
        }
        if (this.counter == 0) {
            this.parent.encodeFrame(frame);
        }
        ++this.counter;
        if (this.counter >= this.decimation) {
            this.counter = 0;
        }
    }

    @Override
    public void encodeFrame(Supplier<T> frame) {
        if (this.decimation <= 1) {
            this.parent.encodeFrame(frame);
            return;
        }
        if (this.counter == 0) {
            this.parent.encodeFrame(frame);
        }
        ++this.counter;
        if (this.counter >= this.decimation) {
            this.counter = 0;
        }
    }

    @Override
    public Supplier<T> convertFrame(BufferedImage image) {
        return this.parent.convertFrame(image);
    }
}

