/*
 * Decompiled with CFR 0.152.
 */
package nl.elec332.util.javarecorder.modifiers;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import nl.elec332.util.javarecorder.AbstractDelegatedRecorder;
import nl.elec332.util.javarecorder.api.IRecorder;

public class ThreadedRecorder<T>
extends AbstractDelegatedRecorder<T> {
    private final Queue<Supplier<T>> unProcessed = new ConcurrentLinkedQueue<Supplier<T>>();
    private final Queue<T> processed = new ConcurrentLinkedQueue<T>();
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    public ThreadedRecorder(IRecorder<T> parent) {
        super(parent);
    }

    @Override
    public void startRecorder(int fps, int width, int height, File file) {
        if (this.isRecording() || this.stopped.get()) {
            throw new IllegalStateException();
        }
        this.parent.startRecorder(fps, width, height, file);
        Thread preProcessor = new Thread(() -> {
            do {
                Queue<Supplier<T>> queue = this.unProcessed;
                synchronized (queue) {
                    while (this.unProcessed.isEmpty()) {
                        try {
                            this.unProcessed.wait();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                        if (!this.stopped.get()) continue;
                    }
                }
                if (!this.stopped.get()) {
                    Supplier<T> current;
                    long l = System.currentTimeMillis();
                    while ((current = this.unProcessed.poll()) != null) {
                        this.processed.add(current.get());
                        if (System.currentTimeMillis() - l <= 2000L) continue;
                        Queue<T> queue2 = this.processed;
                        synchronized (queue2) {
                            this.processed.notifyAll();
                        }
                    }
                }
                queue = this.processed;
                synchronized (queue) {
                    this.processed.notifyAll();
                }
            } while (!this.stopped.get());
        }, "ImageTransformer");
        new Thread(() -> {
            while (true) {
                Queue<T> queue = this.processed;
                synchronized (queue) {
                    T current;
                    while (this.processed.isEmpty()) {
                        try {
                            this.processed.wait();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                        if (!this.stopped.get()) continue;
                    }
                    while ((current = this.processed.poll()) != null) {
                        try {
                            this.parent.encodeFrame(current);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (this.stopped.get()) {
                        this.unProcessed.clear();
                        preProcessor.interrupt();
                        this.parent.stopRecorder();
                        this.processed.clear();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        System.gc();
                        this.stopped.set(false);
                        return;
                    }
                }
            }
        }, "Encoder").start();
        preProcessor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRecorder() {
        System.out.println("STOPRECORDWER");
        this.stopped.set(true);
        Queue<Supplier<T>> queue = this.unProcessed;
        synchronized (queue) {
            this.unProcessed.notifyAll();
        }
        System.out.println("STOPRECORDWERDONE");
    }

    @Override
    public boolean isRecording() {
        if (this.stopped.get()) {
            return false;
        }
        return this.parent.isRecording() && !this.stopped.get();
    }

    @Override
    public void encodeFrame(T frame) {
        if (this.stopped.get()) {
            return;
        }
        this.parent.encodeFrame(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeFrame(Supplier<T> frame) {
        if (frame == null || this.stopped.get()) {
            return;
        }
        this.unProcessed.add(frame);
        Queue<Supplier<T>> queue = this.unProcessed;
        synchronized (queue) {
            this.unProcessed.notifyAll();
        }
    }

    @Override
    public Supplier<T> convertFrame(BufferedImage image) {
        ColorModel cm = image.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = image.getData().createCompatibleWritableRaster();
        image.copyData(raster);
        return this.parent.convertFrame(new BufferedImage(cm, raster, isAlphaPremultiplied, null));
    }
}

