/*
 * Decompiled with CFR 0.152.
 */
package nl.elmar.solr.client;

import java.io.Serializable;
import java.time.LocalDate;
import nl.elmar.solr.client.JsonRenderCommon$;
import nl.elmar.solr.client.JsonRenderCommon$JsPathOps$;
import nl.elmar.solr.request.FacetDefinition;
import nl.elmar.solr.request.FacetMetadata;
import nl.elmar.solr.request.FilterExpression;
import nl.elmar.solr.request.Query;
import nl.elmar.solr.request.ResultGrouping;
import nl.elmar.solr.request.SortOrder;
import nl.elmar.solr.request.SortOrder$Asc$;
import nl.elmar.solr.request.SortOrder$Desc$;
import nl.elmar.solr.request.Sorting;
import nl.elmar.solr.request.ValueExpression;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsObject$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.OWrites;
import play.api.libs.json.OWrites$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.json.package$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.Tuple8;
import scala.Tuple9;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class QueryWriter$ {
    public static QueryWriter$ MODULE$;
    private final Writes<Sorting> sortingWriter;
    private final Writes<FilterExpression> filterDefinitionWriter;
    private final Writes<FacetMetadata.Domain> facetMetadataDomainWriter;
    private final Writes<FacetMetadata.Terms> termsMetadataWriter;
    private final Writes<Enumeration.Value> rangeIncludeWriter;
    private final Writes<FacetMetadata.Range> rangeMetadataWriter;
    private final Writes<FacetMetadata.Unique> uniqueMetadataWriter;
    private final Writes<FacetMetadata> facetMetadataWriter;
    private final OWrites<List<FacetDefinition>> facetListWriter;
    private final Writes<ResultGrouping> resultGroupingWriter;
    private final Writes<List<String>> routingListWriter;
    private final Writes<Query> queryWriter;

    static {
        new QueryWriter$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String renderOrUnrolled(ValueExpression exp) {
        ValueExpression valueExpression = exp;
        if (valueExpression instanceof ValueExpression.OR) {
            ValueExpression.OR oR = (ValueExpression.OR)valueExpression;
            ValueExpression left = oR.left();
            ValueExpression right = oR.right();
            if (left != null) {
                ValueExpression valueExpression2 = left;
                if (right != null) {
                    ValueExpression valueExpression3 = right;
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " OR ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.renderOrUnrolled(valueExpression2), this.renderOrUnrolled(valueExpression3)}));
                }
            }
        }
        if (valueExpression == null) throw new MatchError((Object)valueExpression);
        ValueExpression valueExpression4 = valueExpression;
        return this.renderValueExpression(valueExpression4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String renderAndUnrolled(ValueExpression exp) {
        ValueExpression valueExpression = exp;
        if (valueExpression instanceof ValueExpression.AND) {
            ValueExpression.AND aND = (ValueExpression.AND)valueExpression;
            ValueExpression left = aND.left();
            ValueExpression right = aND.right();
            if (left != null) {
                ValueExpression valueExpression2 = left;
                if (right != null) {
                    ValueExpression valueExpression3 = right;
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " AND ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.renderAndUnrolled(valueExpression2), this.renderAndUnrolled(valueExpression3)}));
                }
            }
        }
        if (valueExpression == null) throw new MatchError((Object)valueExpression);
        ValueExpression valueExpression4 = valueExpression;
        return this.renderValueExpression(valueExpression4);
    }

    public String renderValueExpression(ValueExpression value2) {
        String string;
        ValueExpression valueExpression = value2;
        if (valueExpression instanceof ValueExpression.Term.String) {
            ValueExpression.Term.String string2 = (ValueExpression.Term.String)valueExpression;
            String v = string2.value();
            string = JsonRenderCommon$.MODULE$.OnlyLetterDigit().findAllIn((CharSequence)v).hasNext() ? v : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", "\""})).raw((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v}));
        } else if (valueExpression instanceof ValueExpression.Term.Long) {
            ValueExpression.Term.Long longVal = (ValueExpression.Term.Long)valueExpression;
            long v = longVal.value();
            string = ((Object)BoxesRunTime.boxToLong((long)v)).toString();
        } else if (valueExpression instanceof ValueExpression.Term.Date) {
            ValueExpression.Term.Date date = (ValueExpression.Term.Date)valueExpression;
            LocalDate v = date.value();
            string = JsonRenderCommon$.MODULE$.renderDate(v);
        } else if (valueExpression instanceof ValueExpression.Range) {
            ValueExpression.Range range = (ValueExpression.Range)valueExpression;
            Option<ValueExpression.Term> fromOpt = range.from();
            Option<ValueExpression.Term> toOpt = range.to();
            String from = (String)fromOpt.map((Function1 & Serializable & scala.Serializable)value -> this.renderValueExpression((ValueExpression)value)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "*");
            String to = (String)toOpt.map((Function1 & Serializable & scala.Serializable)value -> this.renderValueExpression((ValueExpression)value)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "*");
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", " TO ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{from, to}));
        } else if (valueExpression instanceof ValueExpression.OR) {
            ValueExpression.OR oR = (ValueExpression.OR)valueExpression;
            ValueExpression left = oR.left();
            ValueExpression right = oR.right();
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " OR ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.renderOrUnrolled(left), this.renderOrUnrolled(right)}));
        } else if (valueExpression instanceof ValueExpression.AND) {
            ValueExpression.AND aND = (ValueExpression.AND)valueExpression;
            ValueExpression left = aND.left();
            ValueExpression right = aND.right();
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " AND ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.renderAndUnrolled(left), this.renderAndUnrolled(right)}));
        } else if (valueExpression instanceof ValueExpression.NOT) {
            ValueExpression.NOT nOT = (ValueExpression.NOT)valueExpression;
            ValueExpression expression = nOT.FilterExpression();
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(NOT ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.renderValueExpression(expression)}));
        } else {
            throw new MatchError((Object)valueExpression);
        }
        return string;
    }

    public String renderFilterExpression(FilterExpression fd) {
        String string;
        FilterExpression filterExpression = fd;
        if (filterExpression instanceof FilterExpression.Field) {
            FilterExpression.Field field = (FilterExpression.Field)filterExpression;
            String fieldName = field.name();
            ValueExpression exp = field.exp();
            Option<String> tagOpt = field.tag();
            String tag2 = (String)tagOpt.map((Function1 & Serializable & scala.Serializable)tag -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{!tag=", "} "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tag}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tag2, fieldName, this.renderValueExpression(exp)}));
        } else if (filterExpression instanceof FilterExpression.OR) {
            FilterExpression.OR oR = (FilterExpression.OR)filterExpression;
            FilterExpression left = oR.left();
            FilterExpression right = oR.right();
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " OR ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.renderFilterExpression(left), this.renderFilterExpression(right)}));
        } else if (filterExpression instanceof ValueExpression) {
            ValueExpression valueExpression = (ValueExpression)filterExpression;
            string = this.renderValueExpression(valueExpression);
        } else {
            throw new MatchError((Object)filterExpression);
        }
        return string;
    }

    public Writes<Sorting> sortingWriter() {
        return this.sortingWriter;
    }

    public Writes<FilterExpression> filterDefinitionWriter() {
        return this.filterDefinitionWriter;
    }

    public Writes<FacetMetadata.Domain> facetMetadataDomainWriter() {
        return this.facetMetadataDomainWriter;
    }

    public Writes<FacetMetadata.Terms> termsMetadataWriter() {
        return this.termsMetadataWriter;
    }

    public Writes<Enumeration.Value> rangeIncludeWriter() {
        return this.rangeIncludeWriter;
    }

    public Writes<FacetMetadata.Range> rangeMetadataWriter() {
        return this.rangeMetadataWriter;
    }

    public Writes<FacetMetadata.Unique> uniqueMetadataWriter() {
        return this.uniqueMetadataWriter;
    }

    public Writes<FacetMetadata> facetMetadataWriter() {
        return this.facetMetadataWriter;
    }

    public OWrites<List<FacetDefinition>> facetListWriter() {
        return this.facetListWriter;
    }

    public Writes<ResultGrouping> resultGroupingWriter() {
        return this.resultGroupingWriter;
    }

    public Writes<List<String>> routingListWriter() {
        return this.routingListWriter;
    }

    public Writes<Query> queryWriter() {
        return this.queryWriter;
    }

    public JsValue toJson(Query query) {
        return this.queryWriter().writes((Object)query);
    }

    private QueryWriter$() {
        MODULE$ = this;
        this.sortingWriter = Writes$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x0$3 -> {
            String string;
            Sorting sorting = x0$3;
            if (sorting == null) throw new MatchError((Object)sorting);
            String field = sorting.field();
            SortOrder order = sorting.order();
            SortOrder sortOrder = order;
            if (SortOrder$Asc$.MODULE$.equals(sortOrder)) {
                string = "asc";
            } else {
                if (!SortOrder$Desc$.MODULE$.equals(sortOrder)) throw new MatchError((Object)sortOrder);
                string = "desc";
            }
            String ord = string;
            return new JsString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field, ord})));
        });
        this.filterDefinitionWriter = Writes$.MODULE$.apply((Function1 & Serializable & scala.Serializable)fd -> new JsString(this.renderFilterExpression((FilterExpression)fd)));
        this.facetMetadataDomainWriter = (Writes)play.api.libs.functional.syntax.package$.MODULE$.toContraFunctorOps(JsonRenderCommon$JsPathOps$.MODULE$.writeNonEmptyList$extension(JsonRenderCommon$.MODULE$.JsPathOps(package$.MODULE$.__().$bslash("excludeTags")), Writes$.MODULE$.traversableWrites((Writes)Writes$.MODULE$.StringWrites())), OWrites$.MODULE$.contravariantfunctorOWrites()).contramap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.excludeTags());
        this.termsMetadataWriter = (Writes)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)package$.MODULE$.__().$bslash("type").write((Writes)Writes$.MODULE$.StringWrites()), OWrites$.MODULE$.functionalCanBuildOWrites()).and((Object)package$.MODULE$.__().$bslash("field").write((Writes)Writes$.MODULE$.StringWrites())).and((Object)package$.MODULE$.__().$bslash("limit").writeNullable((Writes)Writes$.MODULE$.LongWrites())).and((Object)package$.MODULE$.__().$bslash("sort").writeNullable(this.sortingWriter())).and(JsonRenderCommon$JsPathOps$.MODULE$.lazyWriteNonEmptyList$extension(JsonRenderCommon$.MODULE$.JsPathOps(package$.MODULE$.__().$bslash("facet")), (Function0 & Serializable & scala.Serializable)() -> this.facetListWriter())).and((Object)package$.MODULE$.__().$bslash("domain").writeNullable(this.facetMetadataDomainWriter())).apply((Function1 & Serializable & scala.Serializable)m -> new Tuple6((Object)"terms", (Object)m.field(), m.limit(), m.sort(), m.subFacets(), m.domain()), OWrites$.MODULE$.contravariantfunctorOWrites());
        this.rangeIncludeWriter = Writes$.MODULE$.apply((Function1 & Serializable & scala.Serializable)include -> new JsString(include.toString().toLowerCase()));
        this.rangeMetadataWriter = (Writes)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)package$.MODULE$.__().$bslash("type").write((Writes)Writes$.MODULE$.StringWrites()), OWrites$.MODULE$.functionalCanBuildOWrites()).and((Object)package$.MODULE$.__().$bslash("field").write((Writes)Writes$.MODULE$.StringWrites())).and((Object)package$.MODULE$.__().$bslash("start").write((Writes)Writes$.MODULE$.LongWrites())).and((Object)package$.MODULE$.__().$bslash("end").write((Writes)Writes$.MODULE$.LongWrites())).and((Object)package$.MODULE$.__().$bslash("gap").write((Writes)Writes$.MODULE$.LongWrites())).and((Object)package$.MODULE$.__().$bslash("sort").writeNullable(this.sortingWriter())).and(JsonRenderCommon$JsPathOps$.MODULE$.writeNonEmptyList$extension(JsonRenderCommon$.MODULE$.JsPathOps(package$.MODULE$.__().$bslash("include")), Writes$.MODULE$.traversableWrites(this.rangeIncludeWriter()))).and(JsonRenderCommon$JsPathOps$.MODULE$.lazyWriteNonEmptyList$extension(JsonRenderCommon$.MODULE$.JsPathOps(package$.MODULE$.__().$bslash("facet")), (Function0 & Serializable & scala.Serializable)() -> this.facetListWriter())).and((Object)package$.MODULE$.__().$bslash("domain").writeNullable(this.facetMetadataDomainWriter())).apply((Function1 & Serializable & scala.Serializable)m -> new Tuple9((Object)"range", (Object)m.field(), (Object)BoxesRunTime.boxToLong((long)m.start()), (Object)BoxesRunTime.boxToLong((long)m.end()), (Object)BoxesRunTime.boxToLong((long)m.gap()), m.sort(), m.include(), m.subFacets(), m.domain()), OWrites$.MODULE$.contravariantfunctorOWrites());
        this.uniqueMetadataWriter = Writes$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x0$6 -> {
            FacetMetadata.Unique unique = x0$6;
            if (unique == null) {
                throw new MatchError((Object)unique);
            }
            String field = unique.field();
            String function = unique.function();
            JsString jsString = new JsString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{function, field})));
            return jsString;
        });
        this.facetMetadataWriter = Writes$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x0$7 -> {
            JsValue jsValue;
            FacetMetadata facetMetadata = x0$7;
            if (facetMetadata instanceof FacetMetadata.Terms) {
                FacetMetadata.Terms terms = (FacetMetadata.Terms)facetMetadata;
                jsValue = Json$.MODULE$.toJson((Object)terms, this.termsMetadataWriter());
            } else if (facetMetadata instanceof FacetMetadata.Range) {
                FacetMetadata.Range range = (FacetMetadata.Range)facetMetadata;
                jsValue = Json$.MODULE$.toJson((Object)range, this.rangeMetadataWriter());
            } else if (facetMetadata instanceof FacetMetadata.Unique) {
                FacetMetadata.Unique unique = (FacetMetadata.Unique)facetMetadata;
                jsValue = Json$.MODULE$.toJson((Object)unique, this.uniqueMetadataWriter());
            } else if (facetMetadata instanceof FacetMetadata.Min) {
                FacetMetadata.Min min = (FacetMetadata.Min)facetMetadata;
                String field = min.field();
                jsValue = new JsString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"min(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field})));
            } else if (facetMetadata instanceof FacetMetadata.Max) {
                FacetMetadata.Max max = (FacetMetadata.Max)facetMetadata;
                String field = max.field();
                jsValue = new JsString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field})));
            } else {
                throw new MatchError((Object)facetMetadata);
            }
            return jsValue;
        });
        this.facetListWriter = OWrites$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x0$4 -> {
            List list = x0$4;
            JsObject jsObject = Nil$.MODULE$.equals(list) ? JsObject$.MODULE$.empty() : (JsObject)list.foldLeft((Object)JsObject$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x0$5, x1$1) -> {
                FacetDefinition facetDefinition;
                JsObject obj;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = new Tuple2(x0$5, x1$1);
                        if (tuple2 == null) break block2;
                        obj = (JsObject)tuple2._1();
                        facetDefinition = (FacetDefinition)tuple2._2();
                        if (facetDefinition != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                String name = facetDefinition.name();
                FacetMetadata metadata = facetDefinition.metadata();
                JsObject jsObject = obj.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)this.facetMetadataWriter().writes((Object)metadata)));
                return jsObject;
            });
            return jsObject;
        });
        this.resultGroupingWriter = (Writes)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)package$.MODULE$.__().$bslash("group").write((Writes)Writes$.MODULE$.BooleanWrites()), OWrites$.MODULE$.functionalCanBuildOWrites()).and((Object)package$.MODULE$.__().$bslash("group.field").write((Writes)Writes$.MODULE$.StringWrites())).and((Object)package$.MODULE$.__().$bslash("group.sort").writeNullable(this.sortingWriter())).apply((Function1 & Serializable & scala.Serializable)rg -> new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)rg.field(), rg.sort()), OWrites$.MODULE$.contravariantfunctorOWrites());
        this.routingListWriter = Writes$.MODULE$.apply((Function1 & Serializable & scala.Serializable)list -> new JsString(((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3 + "!", List$.MODULE$.canBuildFrom())).mkString(",")));
        this.queryWriter = (Writes)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)package$.MODULE$.__().$bslash("query").write((Writes)Writes$.MODULE$.StringWrites()), OWrites$.MODULE$.functionalCanBuildOWrites()).and(JsonRenderCommon$JsPathOps$.MODULE$.writeNonEmptyList$extension(JsonRenderCommon$.MODULE$.JsPathOps(package$.MODULE$.__().$bslash("filter")), Writes$.MODULE$.traversableWrites(this.filterDefinitionWriter()))).and(JsonRenderCommon$JsPathOps$.MODULE$.writeNonEmptyList$extension(JsonRenderCommon$.MODULE$.JsPathOps(package$.MODULE$.__().$bslash("params").$bslash("_route_")), this.routingListWriter())).and((Object)package$.MODULE$.__().$bslash("params").$bslash("sort").writeNullable(this.sortingWriter())).and((Object)package$.MODULE$.__().$bslash("params").$bslash("start").writeNullable((Writes)Writes$.MODULE$.LongWrites())).and((Object)package$.MODULE$.__().$bslash("params").$bslash("rows").writeNullable((Writes)Writes$.MODULE$.LongWrites())).and((Object)package$.MODULE$.__().$bslash("params").writeNullable(this.resultGroupingWriter())).and(JsonRenderCommon$JsPathOps$.MODULE$.writeNonEmptyList$extension(JsonRenderCommon$.MODULE$.JsPathOps(package$.MODULE$.__().$bslash("facet")), this.facetListWriter())).apply((Function1 & Serializable & scala.Serializable)q -> new Tuple8((Object)"*:*", q.filter(), q.routing(), q.sort(), q.start(), q.rows(), q.grouping(), q.facets()), OWrites$.MODULE$.contravariantfunctorOWrites());
    }
}

