package nl.f00f.annotations;

import javax.annotation.Nonnull;
import javax.annotation.meta.TypeQualifierDefault;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * An annotation indicating that all elements in the current scope of the annotation are
 * non-{@code null} by default.
 *
 * Any element that can be {@code null} should be annotated with {@link javax.annotation.Nullable}
 * or {@link javax.annotation.CheckForNull}.
 */
@Nonnull
@Documented
@Target(ElementType.PACKAGE)
@Retention(RetentionPolicy.RUNTIME)
@TypeQualifierDefault({
                ElementType.PACKAGE,
                ElementType.FIELD,
                ElementType.LOCAL_VARIABLE,
                ElementType.METHOD,
                ElementType.PARAMETER,
                ElementType.TYPE_USE
})
public @interface NonnullByDefault {
}
