package nl.f00f.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * An annotation marking a returned collection or object as unmodifiable.
 *
 * It is recommended for collection produces annotated with this to actually return an
 * {@link java.util.Collections.UnmodifiableCollection} or any of its more specific interfaces.
 * This is not enforced however, and it is equally valid to just assume that the API consumer is
 * a reasonable entity.
 *
 * <strong>This only describes the API contract; it is not enforcing const-correctness.</strong>
 */
@Documented
@Target({ElementType.METHOD, ElementType.TYPE_USE})
@Retention(RetentionPolicy.RUNTIME)
public @interface Unmodifiable {
}
