/*
 * Decompiled with CFR 0.152.
 */
package nl.fd.hamcrest.jsoup;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.jsoup.nodes.Element;

public class ElementWithAttribute
extends TypeSafeDiagnosingMatcher<Element> {
    private final String attributeName;
    private final Matcher<? super String> attributeValueMatcher;

    private ElementWithAttribute(String attributeName, Matcher<? super String> attributeValueMatcher) {
        this.attributeName = attributeName;
        this.attributeValueMatcher = attributeValueMatcher;
    }

    protected boolean matchesSafely(Element item, Description mismatchDescription) {
        if (item.hasAttr(this.attributeName)) {
            String value = item.attr(this.attributeName);
            if (!this.attributeValueMatcher.matches((Object)value)) {
                mismatchDescription.appendText("expected attribute with name ").appendValue((Object)this.attributeName).appendText(" and with value matching ").appendDescriptionOf(this.attributeValueMatcher).appendText(" but value was ").appendValue((Object)value);
                return false;
            }
        } else {
            mismatchDescription.appendText("expected attribute with name ").appendValue((Object)this.attributeName).appendText(" but there were none ");
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendValue((Object)this.attributeName).appendText(" ").appendDescriptionOf(this.attributeValueMatcher);
    }

    @Factory
    public static Matcher<Element> hasAttribute(String attributeName, String expectedValue) {
        return new ElementWithAttribute(attributeName, (Matcher<? super String>)Matchers.is((Object)expectedValue));
    }

    @Factory
    public static Matcher<Element> hasAttribute(String attributeName, Matcher<? super String> attributeValueMatcher) {
        return new ElementWithAttribute(attributeName, attributeValueMatcher);
    }

    @Factory
    public static Matcher<Element> hasHref(String expectedValue) {
        return ElementWithAttribute.hasAttribute("href", (Matcher<? super String>)Matchers.is((Object)expectedValue));
    }

    @Factory
    public static Matcher<Element> hasHref(Matcher<? super String> attributeValueMatcher) {
        return ElementWithAttribute.hasAttribute("href", attributeValueMatcher);
    }
}

