/*
 * Decompiled with CFR 0.152.
 */
package nl.fd.hamcrest.jsoup;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.jsoup.nodes.Element;

public class ElementWithClass
extends TypeSafeDiagnosingMatcher<Element> {
    private final String className;

    private ElementWithClass(String className) {
        this.className = className;
    }

    @Factory
    public static Matcher<Element> hasClass(String className) {
        return new ElementWithClass(className);
    }

    protected boolean matchesSafely(Element item, Description mismatchDescription) {
        if (item.hasAttr("class")) {
            List<String> expectedClasses;
            String value = item.attr("class");
            List<String> classes = Arrays.asList(value.split("\\s+"));
            if (!classes.containsAll(expectedClasses = Arrays.asList(this.className.split("\\s+")))) {
                mismatchDescription.appendText("expected classes '").appendValue(expectedClasses).appendText("', but found ").appendValue(classes);
                return false;
            }
        } else {
            mismatchDescription.appendText("expected attribute class ").appendValue((Object)this.className).appendText(" but there were none ");
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendValue((Object)this.className);
    }
}

