/*
 * Decompiled with CFR 0.152.
 */
package nl.fd.hamcrest.jsoup;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.jsoup.nodes.Element;

public class ElementWithName
extends TypeSafeDiagnosingMatcher<Element> {
    private final Matcher<? super String> matcher;

    private ElementWithName(Matcher<? super String> matcher) {
        this.matcher = matcher;
    }

    @Factory
    public static Matcher<Element> hasName(Matcher<? super String> matcher) {
        return new ElementWithName(matcher);
    }

    @Factory
    public static Matcher<Element> hasName(String name) {
        return ElementWithName.hasName((Matcher<? super String>)Matchers.equalTo((Object)name));
    }

    protected boolean matchesSafely(Element item, Description mismatchDescription) {
        String actualName = item.tagName();
        if (!this.matcher.matches((Object)actualName)) {
            mismatchDescription.appendText("element name ");
            this.matcher.describeMismatch((Object)actualName, mismatchDescription);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("element with name ");
        this.matcher.describeTo(description);
    }
}

