/*
 * Decompiled with CFR 0.152.
 */
package nl.fd.hamcrest.jsoup;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.jsoup.nodes.Element;

public class ElementWithOwnText
extends TypeSafeDiagnosingMatcher<Element> {
    private final String text;

    private ElementWithOwnText(String text) {
        this.text = text;
    }

    @Factory
    public static Matcher<Element> hasOwnText(String text) {
        return new ElementWithOwnText(text);
    }

    protected boolean matchesSafely(Element item, Description mismatchDescription) {
        String actualText = item.ownText();
        if (!actualText.equals(this.text)) {
            mismatchDescription.appendText("expected ").appendValue((Object)this.text).appendText(" but was ").appendValue((Object)actualText);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendValue((Object)this.text);
    }
}

