/*
 * Decompiled with CFR 0.152.
 */
package nl.fd.hamcrest.jsoup;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.jsoup.nodes.Element;

public class ElementWithText
extends TypeSafeDiagnosingMatcher<Element> {
    private final Matcher<? super String> textMatcher;

    private ElementWithText(Matcher<? super String> textMatcher) {
        this.textMatcher = textMatcher;
    }

    @Factory
    public static Matcher<Element> hasText(String text) {
        return ElementWithText.hasText((Matcher<? super String>)Matchers.is((Object)text));
    }

    @Factory
    public static Matcher<Element> hasText(Matcher<? super String> textMatcher) {
        return new ElementWithText(textMatcher);
    }

    protected boolean matchesSafely(Element item, Description mismatchDescription) {
        String actualText = item.text();
        if (!this.textMatcher.matches((Object)actualText)) {
            mismatchDescription.appendText("expected element with text matching (").appendDescriptionOf(this.textMatcher).appendText(") but was ").appendValue((Object)actualText);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("element with text ").appendDescriptionOf(this.textMatcher);
    }
}

