/*
 * Decompiled with CFR 0.152.
 */
package nl.fd.hamcrest.jsoup;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class Selecting
extends TypeSafeDiagnosingMatcher<Element> {
    private final String cssExpression;
    private final Matcher<Iterable<Element>> selectionMatcher;

    private Selecting(String cssExpression, Matcher<Iterable<Element>> selectionMatcher) {
        this.cssExpression = cssExpression;
        this.selectionMatcher = selectionMatcher;
    }

    @Factory
    public static Matcher<Element> selecting(String cssExpression, Matcher<Iterable<Element>> elementsMatcher) {
        return new Selecting(cssExpression, elementsMatcher);
    }

    protected boolean matchesSafely(Element item, Description mismatchDescription) {
        Elements elements = item.select(this.cssExpression);
        if (!this.selectionMatcher.matches((Object)elements)) {
            mismatchDescription.appendText("expected element with children selected by ").appendValue((Object)this.cssExpression).appendText(" matching ").appendDescriptionOf(this.selectionMatcher).appendText(" but ");
            this.selectionMatcher.describeMismatch((Object)elements, mismatchDescription);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(" has children selected by ").appendValue((Object)this.cssExpression).appendText(" matching ").appendDescriptionOf(this.selectionMatcher);
    }
}

