/*
 * Decompiled with CFR 0.152.
 */
package nl.fd.hamcrest.jsoup;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ElementWithChild
extends TypeSafeDiagnosingMatcher<Element> {
    private String cssSelector;

    private ElementWithChild(String cssSelector) {
        this.cssSelector = cssSelector;
    }

    protected boolean matchesSafely(Element parent, Description description) {
        Elements elements = parent.select(this.cssSelector);
        if (elements.isEmpty()) {
            description.appendText("expected element to have at least one child matching selector ").appendValue((Object)this.cssSelector).appendText(" but nothing found.");
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(" has child selected by ").appendValue((Object)this.cssSelector);
    }

    @Factory
    public static Matcher<Element> hasChild(String cssSelector) {
        return new ElementWithChild(cssSelector);
    }
}

