/*
 * Decompiled with CFR 0.152.
 */
package nl.fd.hamcrest.jsoup;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ElementWithUniqueChild
extends TypeSafeDiagnosingMatcher<Element> {
    private String cssSelector;

    private ElementWithUniqueChild(String cssSelector) {
        this.cssSelector = cssSelector;
    }

    protected boolean matchesSafely(Element parent, Description description) {
        Elements elements = parent.select(this.cssSelector);
        if (elements.isEmpty()) {
            description.appendText("expected element to have exactly one child matching selector ").appendValue((Object)this.cssSelector).appendText(" but nothing found.");
            return false;
        }
        if (elements.isEmpty() || elements.size() > 1) {
            description.appendText("expected element to have exactly one child matching selector ").appendValue((Object)this.cssSelector).appendText(" but ").appendText(String.valueOf(elements.size())).appendText(" found.");
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(" has child selected by ").appendValue((Object)this.cssSelector);
    }

    @Factory
    public static Matcher<Element> hasUniqueChild(String cssSelector) {
        return new ElementWithUniqueChild(cssSelector);
    }
}

