/*
 * Decompiled with CFR 0.152.
 */
package nl.fd.hamcrest.jsoup;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class SelectingFirst
extends TypeSafeDiagnosingMatcher<Element> {
    private final String cssExpression;
    private final Matcher<Element> selectionMatcher;

    public SelectingFirst(String cssExpression, Matcher<Element> selectionMatcher) {
        this.cssExpression = cssExpression;
        this.selectionMatcher = selectionMatcher;
    }

    protected boolean matchesSafely(Element item, Description mismatchDescription) {
        Elements elements = item.select(this.cssExpression);
        Element element = elements.first();
        if (!this.selectionMatcher.matches((Object)element)) {
            mismatchDescription.appendText("expected element with child selected by ").appendValue((Object)this.cssExpression).appendText(" matching ").appendDescriptionOf(this.selectionMatcher).appendText(" but ");
            this.selectionMatcher.describeMismatch((Object)element, mismatchDescription);
            return false;
        }
        return true;
    }

    @Factory
    public static Matcher<Element> selectingFirst(String cssExpression, Matcher<Element> elementMatcher) {
        return new SelectingFirst(cssExpression, elementMatcher);
    }

    public void describeTo(Description description) {
        description.appendText(" has child selected by ").appendValue((Object)this.cssExpression).appendText(" matching ").appendDescriptionOf(this.selectionMatcher);
    }
}

