/*
 * Decompiled with CFR 0.152.
 */
package nl.goodbytes.xmpp.xep0363.repository;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import nl.goodbytes.xmpp.xep0363.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileSystemRepository
implements Repository {
    private static final Logger Log = LoggerFactory.getLogger(AbstractFileSystemRepository.class);
    private Timer timer;
    protected Path repository;

    protected abstract Path initializeRepository() throws IOException;

    @Override
    public void initialize() throws IOException {
        this.repository = this.initializeRepository();
        this.purge();
        this.timer = new Timer("xmppfileupload-cleanup", true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    AbstractFileSystemRepository.this.purge();
                }
                catch (Exception e) {
                    Log.warn("An unexpected error occurred while purging the repository.", (Throwable)e);
                }
            }
        }, 300000L, 300000L);
        Log.info("Initialized repository in: {}", (Object)this.repository);
    }

    @Override
    public void destroy() throws IOException {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Override
    public boolean contains(UUID uuid) throws IOException {
        Path path = Paths.get(this.repository.toString(), uuid.toString());
        boolean result = Files.exists(path, new LinkOption[0]);
        Log.debug("UUID '{}' {} exist in respository.", (Object)uuid, (Object)(result ? "does" : "does not"));
        return result;
    }

    @Override
    public String calculateETagHash(UUID uuid) throws IOException {
        Path path = Paths.get(this.repository.toString(), uuid.toString());
        String result = String.valueOf(path.hashCode() + Files.getLastModifiedTime(path, new LinkOption[0]).hashCode());
        Log.debug("UUID '{}' ETag value: {}", (Object)uuid, (Object)result);
        return result;
    }

    @Override
    public String getContentType(UUID uuid) throws IOException {
        Path path = Paths.get(this.repository.toString(), uuid.toString());
        String result = Files.probeContentType(path);
        Log.debug("UUID '{}' content type: {}", (Object)uuid, (Object)result);
        return result;
    }

    @Override
    public long getSize(UUID uuid) throws IOException {
        Path path = Paths.get(this.repository.toString(), uuid.toString());
        long result = Files.size(path);
        Log.debug("UUID '{}' size: {} bytes", (Object)uuid, (Object)result);
        return result;
    }

    @Override
    public InputStream getInputStream(UUID uuid) throws IOException {
        Path path = Paths.get(this.repository.toString(), uuid.toString());
        return Files.newInputStream(path, StandardOpenOption.READ);
    }

    @Override
    public OutputStream getOutputStream(UUID uuid) throws IOException {
        Path path = Paths.get(this.repository.toString(), uuid.toString());
        return Files.newOutputStream(path, StandardOpenOption.CREATE);
    }

    public void purge() throws IOException {
        File[] files = this.repository.toFile().listFiles();
        if (files == null) {
            Log.debug("No need to purge the repository, as it does not contain any files.");
            return;
        }
        long used = AbstractFileSystemRepository.getUsedSpace(this.repository);
        long free = AbstractFileSystemRepository.getUsableSpace(this.repository);
        Log.debug("The repository currently uses {} bytes, while there's {} bytes of usable space left.", (Object)used, (Object)free);
        if (used == 0L || used < free) {
            Log.debug("No need to purge the repository, as the free space is larger than the used space.");
            return;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return Long.compare(o1.lastModified(), o2.lastModified());
            }
        });
        long deletedTotal = 0L;
        for (File file : files) {
            long deleted = AbstractFileSystemRepository.delete(file.toPath());
            Log.debug("Purging repository: deleting: {} ({} bytes)", (Object)file, (Object)deleted);
            if (used - (deletedTotal += deleted) <= 0L || used - deletedTotal < free + deletedTotal) break;
        }
        Log.info("The repository was purged: {} bytes were deleted.", (Object)deletedTotal);
    }

    protected static long getUsableSpace(Path path) throws IOException {
        return Files.getFileStore(path).getUsableSpace();
    }

    public static long getUsedSpace(Path path) throws IOException {
        final AtomicLong size = new AtomicLong(0L);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                size.addAndGet(attrs.size());
                return FileVisitResult.CONTINUE;
            }
        });
        return size.get();
    }

    protected static long delete(Path path) throws IOException {
        final AtomicLong size = new AtomicLong(0L);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                size.addAndGet(attrs.size());
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
        return size.get();
    }
}

