/*
 * Decompiled with CFR 0.152.
 */
package nl.goodbytes.xmpp.xep0363;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.goodbytes.xmpp.xep0363.Repository;
import nl.goodbytes.xmpp.xep0363.RepositoryManager;
import nl.goodbytes.xmpp.xep0363.Slot;
import nl.goodbytes.xmpp.xep0363.SlotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Servlet
extends HttpServlet {
    private static final Logger Log = LoggerFactory.getLogger(Servlet.class);

    public static UUID uuidFromPath(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        String[] parts = path.split("/");
        if (parts.length < 2) {
            return null;
        }
        try {
            return UUID.fromString(parts[parts.length - 2]);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long size;
        String calculatedETagHash;
        Log.info("Processing GET request... ({} requesting from {})", (Object)req.getRemoteAddr(), (Object)req.getRequestURI());
        Repository repository = RepositoryManager.getInstance().getRepository();
        if (repository == null) {
            resp.sendError(500);
            Log.warn("... responded with INTERNAL_SERVER_ERROR. The repository is null.");
            return;
        }
        UUID uuid = Servlet.uuidFromPath(req.getRequestURI());
        if (uuid == null) {
            resp.sendError(404);
            Log.info("... responded with NOT_FOUND. Unable to parse UUID from request URI.");
            return;
        }
        if (!repository.contains(uuid)) {
            resp.sendError(404);
            Log.info("... responded with NOT_FOUND. The repository does not contain a path to the UUID that is parsed from request URI: {}", (Object)uuid.toString());
            return;
        }
        String eTagRequest = req.getHeader("If-None-Match");
        if (eTagRequest != null && eTagRequest.equals(calculatedETagHash = repository.calculateETagHash(uuid))) {
            resp.setStatus(304);
            Log.info("... responded with NOT_MODIFIED. Provided ETag value matches the hash in the repository.");
            return;
        }
        String contentType = repository.getContentType(uuid);
        if (contentType != null && !contentType.isEmpty()) {
            resp.setContentType(contentType);
            Log.debug("... setting content type '{}'.", (Object)contentType);
        }
        if ((size = repository.getSize(uuid)) > 0L && size <= Integer.MAX_VALUE) {
            resp.setContentLength((int)size);
            Log.debug("... setting content length '{}'.", (Object)size);
        }
        resp.setHeader("Cache-Control", "max-age=31536000");
        String etag = repository.calculateETagHash(uuid);
        if (etag != null) {
            resp.setHeader("ETag", etag);
            Log.debug("... setting ETag '{}'.", (Object)etag);
        }
        try (BufferedInputStream in = new BufferedInputStream(repository.getInputStream(uuid));
             ServletOutputStream out = resp.getOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        Log.info("... responded with OK and included the data in the response body.");
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Log.info("Processing PUT request... ({} submitting to {})", (Object)req.getRemoteAddr(), (Object)req.getRequestURI());
        Repository repository = RepositoryManager.getInstance().getRepository();
        if (repository == null) {
            resp.sendError(500);
            Log.warn("... responded with INTERNAL_SERVER_ERROR. The repository is null.");
            return;
        }
        UUID uuid = Servlet.uuidFromPath(req.getRequestURI());
        if (uuid == null) {
            resp.sendError(400, "The request lacks a slot identifier on its path.");
            Log.info("... responded with BAD_REQUEST. The request lacks a slot identifier on its path.");
            return;
        }
        Slot slot = SlotManager.getInstance().consumeSlotForPut(uuid);
        if (slot == null) {
            resp.sendError(400, "The requested slot is not available. Either it does not exist, or has already been used.");
            Log.info("... responded with BAD_REQUEST. The requested slot is not available. Either it does not exist, or has already been used.");
            return;
        }
        if ((long)req.getContentLength() != slot.getSize()) {
            resp.sendError(400, "Content length in request does not correspond with slot size.");
            Log.info("... responded with BAD_REQUEST. Content length in request ({}) does not correspond with slot size ({}).", (Object)req.getContentLength(), (Object)slot.getSize());
            return;
        }
        try (ServletInputStream in = req.getInputStream();
             BufferedOutputStream out = new BufferedOutputStream(repository.getOutputStream(slot.getUuid()));){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, bytesRead);
            }
        }
        try {
            resp.setHeader("Location", slot.getGetUrl().toExternalForm());
        }
        catch (MalformedURLException | URISyntaxException e) {
            Log.warn("Unable to calculate GET URL for {}", (Object)slot, (Object)e);
        }
        resp.setStatus(201);
        Log.info("... responded with CREATED. Stored data from the request body in the repository.");
    }
}

