/*
 * Decompiled with CFR 0.152.
 */
package nl.goodbytes.xmpp.xep0363;

import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import nl.goodbytes.xmpp.xep0363.Slot;
import nl.goodbytes.xmpp.xep0363.SlotManager;
import nl.goodbytes.xmpp.xep0363.TooLargeException;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.AbstractComponent;
import org.xmpp.packet.IQ;
import org.xmpp.packet.PacketError;

public class Component
extends AbstractComponent {
    public static final String NAMESPACE_EXP = "urn:xmpp:http:upload";
    public static final String NAMESPACE = "urn:xmpp:http:upload:0";
    private static final Logger Log = LoggerFactory.getLogger(Component.class);
    private final String name;

    public Component(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Argument 'name' cannot be null or an empty String.");
        }
        this.name = name.trim();
    }

    public String getDescription() {
        return "HTTP File Upload, an implementation of XEP-0363, supporting exchange of files between XMPP entities.";
    }

    public String getName() {
        return this.name;
    }

    protected String discoInfoIdentityCategory() {
        return "store";
    }

    protected String discoInfoIdentityCategoryType() {
        return "file";
    }

    protected String[] discoInfoFeatureNamespaces() {
        return new String[]{NAMESPACE, NAMESPACE_EXP};
    }

    protected IQ handleDiscoInfo(IQ iq) {
        IQ response = super.handleDiscoInfo(iq);
        if (SlotManager.getInstance().getMaxFileSize() > 0L) {
            Element configForm = response.getChildElement().addElement("x", "jabber:x:data");
            configForm.addAttribute("type", "result");
            configForm.addElement("field").addAttribute("var", "FORM_TYPE").addAttribute("type", "hidden").addElement("value").addText(NAMESPACE);
            configForm.addElement("field").addAttribute("var", "max-file-size").addElement("value").addText(Long.toString(SlotManager.getInstance().getMaxFileSize()));
        }
        return response;
    }

    protected IQ handleIQGet(IQ iq) throws Exception {
        Slot slot;
        long fileSize;
        Element request = iq.getChildElement();
        List<String> namespaces = Arrays.asList(NAMESPACE, NAMESPACE_EXP);
        if ("query".equals(request.getQName().getName()) && "jabber:iq:version".equals(request.getNamespaceURI())) {
            try {
                Element answerElement = DocumentHelper.createElement((QName)QName.get((String)"query", (String)"jabber:iq:version"));
                MavenXpp3Reader reader = new MavenXpp3Reader();
                Model model = reader.read((Reader)new FileReader("pom.xml"));
                if (model.getName() != null) {
                    answerElement.addElement("name").setText(model.getName());
                }
                if (model.getDescription() != null) {
                    answerElement.addElement("description").setText(model.getDescription());
                }
                if (model.getVersion() != null) {
                    answerElement.addElement("version").setText(model.getVersion());
                }
                String os = System.getProperty("os.name") + ' ' + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ')';
                String java = "Java " + System.getProperty("java.version");
                answerElement.addElement("os").setText(os + " - " + java);
                IQ result = IQ.createResultIQ((IQ)iq);
                result.setChildElement(answerElement);
                return result;
            }
            catch (Exception ex) {
                IQ result = IQ.createResultIQ((IQ)iq);
                PacketError error = new PacketError(PacketError.Condition.not_acceptable);
                result.setError(error);
                return result;
            }
        }
        if (!namespaces.contains(request.getNamespaceURI()) || !request.getName().equals("request")) {
            return null;
        }
        boolean isPre030Style = NAMESPACE_EXP.equals(request.getNamespaceURI());
        Log.info("Entity '{}' tries to obtain slot.", (Object)iq.getFrom());
        String fileName = null;
        if (request.attributeValue("filename") != null && !request.attributeValue("filename").trim().isEmpty()) {
            fileName = request.attributeValue("filename").trim();
        }
        if (request.element("filename") != null && !request.element("filename").getTextTrim().isEmpty()) {
            fileName = request.element("filename").getTextTrim();
        }
        if (fileName == null) {
            IQ response = IQ.createResultIQ((IQ)iq);
            response.setError(PacketError.Condition.bad_request);
            return response;
        }
        String size = null;
        if (request.attributeValue("size") != null && !request.attributeValue("size").isEmpty()) {
            size = request.attributeValue("size").trim();
        }
        if (request.element("size") != null && !request.element("size").getTextTrim().isEmpty()) {
            size = request.element("size").getTextTrim();
        }
        if (size == null) {
            IQ response = IQ.createResultIQ((IQ)iq);
            response.setError(PacketError.Condition.bad_request);
            return response;
        }
        try {
            fileSize = Long.parseLong(size);
        }
        catch (NumberFormatException e) {
            IQ response = IQ.createResultIQ((IQ)iq);
            response.setError(PacketError.Condition.bad_request);
            return response;
        }
        SlotManager manager = SlotManager.getInstance();
        try {
            slot = manager.getSlot(iq.getFrom(), fileName, fileSize);
        }
        catch (TooLargeException ex) {
            IQ response = IQ.createResultIQ((IQ)iq);
            PacketError error = new PacketError(PacketError.Condition.not_acceptable, PacketError.Type.modify, "File too large. Maximum file size is " + ex.getMaximum() + " bytes.");
            error.getElement().addElement("file-too-large", iq.getChildElement().getNamespaceURI()).addElement("max-file-size").addText(Long.toString(ex.getMaximum()));
            response.setError(error);
            return response;
        }
        URL putUrl = slot.getPutUrl();
        URL getUrl = slot.getGetUrl();
        Log.info("Entity '{}' obtained slot for '{}' ({} bytes). PUT-URL: {} GET-URL: {}", new Object[]{iq.getFrom(), fileName, fileSize, putUrl, getUrl});
        IQ response = IQ.createResultIQ((IQ)iq);
        Element slotElement = response.setChildElement("slot", iq.getChildElement().getNamespaceURI());
        if (isPre030Style) {
            slotElement.addElement("put").setText(putUrl.toExternalForm());
            slotElement.addElement("get").setText(getUrl.toExternalForm());
        } else {
            slotElement.addElement("put").addAttribute("url", putUrl.toExternalForm());
            slotElement.addElement("get").addAttribute("url", getUrl.toExternalForm());
        }
        return response;
    }
}

