/*
 * Decompiled with CFR 0.152.
 */
package nl.goodbytes.xmpp.xep0363;

import java.util.Objects;
import java.util.UUID;
import nl.goodbytes.xmpp.xep0363.SecureUniqueId;

public class LegacyUUID
implements SecureUniqueId {
    private UUID uuid;

    private LegacyUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public static LegacyUUID generate() {
        UUID u = UUID.randomUUID();
        return new LegacyUUID(u);
    }

    public static LegacyUUID fromString(String s) {
        UUID u = UUID.fromString(s);
        return new LegacyUUID(u);
    }

    @Override
    public int compareTo(SecureUniqueId o) {
        if (this.uuid == null) {
            throw new UnsupportedOperationException();
        }
        if (o != null && o instanceof LegacyUUID) {
            return this.uuid.compareTo(((LegacyUUID)o).uuid);
        }
        return -1;
    }

    public int hashCode() {
        if (this.uuid == null) {
            return System.identityHashCode(this);
        }
        return Objects.hash(this.uuid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this.uuid == null) {
            return false;
        }
        LegacyUUID other = (LegacyUUID)LegacyUUID.class.cast(obj);
        return Objects.equals(this.uuid, other.uuid);
    }

    public String toString() {
        if (this.uuid != null) {
            return this.uuid.toString();
        }
        throw new UnsupportedOperationException();
    }
}

