/*
 * Decompiled with CFR 0.152.
 */
package nl.goodbytes.xmpp.xep0363;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import nl.goodbytes.xmpp.xep0363.SecureUniqueId;
import nl.goodbytes.xmpp.xep0363.Slot;
import nl.goodbytes.xmpp.xep0363.TooLargeException;
import org.xmpp.packet.JID;

public class SlotManager {
    public static final long DEFAULT_MAX_FILE_SIZE = 0x3200000L;
    private static SlotManager INSTANCE = null;
    private final Cache<SecureUniqueId, Slot> slots;
    private long maxFileSize = 0x3200000L;
    private long putExpiryValue = 5L;
    private TimeUnit putExpiryUnit = TimeUnit.MINUTES;
    private String webProtocol;
    private String webHost;
    private Integer webPort;
    private String webContextRoot;

    private SlotManager() {
        this.slots = CacheBuilder.newBuilder().expireAfterWrite(this.putExpiryValue, this.putExpiryUnit).build();
    }

    public static synchronized SlotManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SlotManager();
        }
        return INSTANCE;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public Slot getSlot(JID from, String fileName, long fileSize) throws TooLargeException {
        if (this.maxFileSize > 0L && fileSize > this.maxFileSize) {
            throw new TooLargeException(fileSize, this.maxFileSize);
        }
        Slot slot = new Slot(from, fileName, fileSize);
        this.slots.put((Object)slot.getUuid(), (Object)slot);
        return slot;
    }

    public Slot consumeSlotForPut(SecureUniqueId uuid) {
        Slot slot = (Slot)this.slots.getIfPresent((Object)uuid);
        if (slot != null) {
            this.slots.invalidate((Object)uuid);
        }
        return slot;
    }

    public void setWebProtocol(String webProtocol) {
        this.webProtocol = webProtocol;
    }

    public String getWebProtocol() {
        return this.webProtocol;
    }

    public void setWebHost(String webHost) {
        this.webHost = webHost;
    }

    public String getWebHost() {
        return this.webHost;
    }

    public void setWebPort(int webPort) {
        this.webPort = webPort;
    }

    public int getWebPort() {
        return this.webPort;
    }

    public String getWebContextRoot() {
        return this.webContextRoot;
    }

    public void setWebContextRoot(String webContextRoot) {
        this.webContextRoot = webContextRoot;
    }
}

