/*
 * Decompiled with CFR 0.152.
 */
package nl.goodbytes.xmpp.xep0363;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nonnull;
import nl.goodbytes.xmpp.xep0363.SecureUniqueId;
import nl.goodbytes.xmpp.xep0363.Slot;
import nl.goodbytes.xmpp.xep0363.SlotProvider;
import nl.goodbytes.xmpp.xep0363.TooLargeException;
import org.xmpp.packet.JID;

public class SlotManager {
    public static final long DEFAULT_MAX_FILE_SIZE = 0x3200000L;
    private long maxFileSize = 0x3200000L;
    private static SlotManager INSTANCE = null;
    private SlotProvider slotProvider;
    private String webProtocol;
    private String webHost;
    private Integer webPort;
    private String webContextRoot;

    public static synchronized SlotManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SlotManager();
        }
        return INSTANCE;
    }

    public void initialize(SlotProvider slotProvider) {
        if (this.slotProvider != null) {
            throw new IllegalArgumentException("Already initialized.");
        }
        this.slotProvider = slotProvider;
    }

    public Long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(Long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public Slot getSlot(JID from, String fileName, long fileSize) throws TooLargeException {
        if (this.maxFileSize > 0L && fileSize > this.maxFileSize) {
            throw new TooLargeException(fileSize, this.maxFileSize);
        }
        Slot slot = new Slot(from, fileName, fileSize);
        this.slotProvider.create(slot);
        return slot;
    }

    public Slot consumeSlotForPut(SecureUniqueId uuid) {
        return this.slotProvider.consume(uuid);
    }

    public static URL getPutUrl(@Nonnull Slot slot) throws URISyntaxException, MalformedURLException {
        return SlotManager.getURL(slot);
    }

    public static URL getGetUrl(@Nonnull Slot slot) throws URISyntaxException, MalformedURLException {
        return SlotManager.getURL(slot);
    }

    private static URL getURL(@Nonnull Slot slot) throws URISyntaxException, MalformedURLException {
        String path = SlotManager.getInstance().getWebContextRoot().endsWith("/") ? SlotManager.getInstance().getWebContextRoot() + slot.getUuid() + "/" + slot.getFilename() : SlotManager.getInstance().getWebContextRoot() + "/" + slot.getUuid() + "/" + slot.getFilename();
        URI uri = new URI(SlotManager.getInstance().getWebProtocol(), null, SlotManager.getInstance().getWebHost(), SlotManager.getInstance().getWebPort(), path, null, null);
        String usascii = uri.toASCIIString();
        return new URL(usascii);
    }

    public void setWebProtocol(String webProtocol) {
        this.webProtocol = webProtocol;
    }

    public String getWebProtocol() {
        return this.webProtocol;
    }

    public void setWebHost(String webHost) {
        this.webHost = webHost;
    }

    public String getWebHost() {
        return this.webHost;
    }

    public void setWebPort(int webPort) {
        this.webPort = webPort;
    }

    public Integer getWebPort() {
        return this.webPort;
    }

    public String getWebContextRoot() {
        return this.webContextRoot;
    }

    public void setWebContextRoot(String webContextRoot) {
        this.webContextRoot = webContextRoot;
    }
}

