/*
 * Decompiled with CFR 0.152.
 */
package nl.goodbytes.xmpp.xep0363.slot;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nl.goodbytes.xmpp.xep0363.SecureUniqueId;
import nl.goodbytes.xmpp.xep0363.Slot;
import nl.goodbytes.xmpp.xep0363.SlotProvider;

public class DefaultSlotProvider
implements SlotProvider {
    private final Cache<SecureUniqueId, Slot> slots;
    private long putExpiryValue = 5L;
    private TimeUnit putExpiryUnit = TimeUnit.MINUTES;

    public DefaultSlotProvider() {
        this.slots = CacheBuilder.newBuilder().expireAfterWrite(this.putExpiryValue, this.putExpiryUnit).build();
    }

    @Override
    public void create(@Nonnull Slot slot) {
        this.slots.put((Object)slot.getUuid(), (Object)slot);
    }

    @Override
    @Nullable
    public Slot consume(@Nonnull SecureUniqueId uuid) {
        Slot slot = (Slot)this.slots.getIfPresent((Object)uuid);
        if (slot != null) {
            this.slots.invalidate((Object)uuid);
        }
        return slot;
    }
}

