/*
 * Copyright (c) 2023 Guus der Kinderen. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.goodbytes.xmpp.xep0363;

import java.io.IOException;

public class MalwareScannerManager
{
    private static MalwareScannerManager INSTANCE;

    public synchronized static MalwareScannerManager getInstance()
    {
        if (INSTANCE == null) {
            INSTANCE = new MalwareScannerManager();
        }

        return INSTANCE;
    }

    private MalwareScanner malwareScanner;

    public boolean isEnabled() {
        return this.malwareScanner != null;
    }

    public void initialize(final MalwareScanner malwareScanner) throws IOException
    {
        if (this.malwareScanner != null) {
            throw new IllegalArgumentException("Already initialized.");
        }
        this.malwareScanner = malwareScanner;
        this.malwareScanner.initialize();
    }

    public MalwareScanner getMalwareScanner()
    {
        return this.malwareScanner;
    }

    public void destroy()
    {
        if (this.malwareScanner != null) {
            this.malwareScanner.destroy();
            this.malwareScanner = null;
        }
    }
}
