/*
 * Decompiled with CFR 0.152.
 */
package nl.goodbytes.xmpp.xep0363;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Enumeration;
import nl.goodbytes.xmpp.xep0363.Component;
import nl.goodbytes.xmpp.xep0363.MalwareScanner;
import nl.goodbytes.xmpp.xep0363.MalwareScannerManager;
import nl.goodbytes.xmpp.xep0363.Repository;
import nl.goodbytes.xmpp.xep0363.RepositoryManager;
import nl.goodbytes.xmpp.xep0363.Servlet;
import nl.goodbytes.xmpp.xep0363.SlotManager;
import nl.goodbytes.xmpp.xep0363.SlotProvider;
import nl.goodbytes.xmpp.xep0363.clamav.ClamavMalwareScanner;
import nl.goodbytes.xmpp.xep0363.repository.AbstractFileSystemRepository;
import nl.goodbytes.xmpp.xep0363.repository.DirectoryRepository;
import nl.goodbytes.xmpp.xep0363.repository.TempDirectoryRepository;
import nl.goodbytes.xmpp.xep0363.slot.DefaultSlotProvider;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.jivesoftware.whack.ExternalComponentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher {
    private static final Logger Log = LoggerFactory.getLogger(Launcher.class);
    private final String xmppHost;
    private final Integer xmppPort;
    private final String webContextRoot;
    private final String domain;
    private final String sharedSecret;
    private final String webProtocol;
    private final String webHost;
    private final Integer webPort;
    private final String announcedWebProtocol;
    private final String announcedWebHost;
    private final Integer announcedWebPort;
    private final String announcedWebContextRoot;
    private final Repository repository;
    private final SlotProvider slotProvider;
    private final Long maxFileSize;
    private final boolean wildcardCORS;
    private final MalwareScanner malwareScanner;

    public Launcher(String xmppHost, Integer xmppPort, String domain, String sharedSecret, String webProtocol, String webHost, Integer webPort, String webContextRoot, String announcedWebProtocol, String announcedWebHost, Integer announcedWebPort, String announcedWebContextRoot, Repository repository, Long maxFileSize, boolean wildcardCORS, MalwareScanner malwareScanner) {
        this.xmppHost = xmppHost != null ? xmppHost : "localhost";
        this.xmppPort = xmppPort != null ? xmppPort : 5275;
        this.domain = domain != null ? domain : "upload";
        this.sharedSecret = sharedSecret;
        this.webProtocol = webProtocol != null ? webProtocol : "http";
        this.webHost = webHost != null ? webHost : Launcher.getPublicAddress();
        this.webPort = webPort != null ? webPort : 12121;
        this.webContextRoot = webContextRoot != null ? (webContextRoot.startsWith("/") ? webContextRoot : "/" + webContextRoot) : "/";
        this.announcedWebProtocol = announcedWebProtocol != null ? announcedWebProtocol : this.webProtocol;
        this.announcedWebHost = announcedWebHost != null ? announcedWebHost : this.webHost;
        this.announcedWebPort = announcedWebPort != null ? announcedWebPort : this.webPort;
        this.announcedWebContextRoot = announcedWebContextRoot != null ? announcedWebContextRoot : this.webContextRoot;
        this.repository = repository != null ? repository : new TempDirectoryRepository();
        this.slotProvider = new DefaultSlotProvider();
        this.maxFileSize = maxFileSize != null ? maxFileSize : 0x3200000L;
        this.wildcardCORS = wildcardCORS;
        this.malwareScanner = malwareScanner;
    }

    public static void main(String[] args) {
        block9: {
            Options options = new Options();
            options.addOption(Option.builder((String)"h").longOpt("help").desc("Displays this help text.").build());
            options.addOption(Option.builder().longOpt("webProtocol").hasArg().desc("The protocol that is used to expose services by the webservice. Defaults to http").build());
            options.addOption(Option.builder().longOpt("webHost").hasArg().desc("The hostname or IP address on which the webserver will be ran. Defaults to an arbitrary, non-local address of this machine.").build());
            options.addOption(Option.builder().longOpt("webPort").hasArg().desc("The TCP port number of the webserver. Defaults to 12121.").type(Integer.class).build());
            options.addOption(Option.builder().longOpt("webContextRoot").hasArg().desc("The context root of the web server through which the web frontend will be made available. Defaults to '/', the root context.").build());
            options.addOption(Option.builder().longOpt("announcedWebProtocol").hasArg().desc("The Protocol that is to be used by the end users. Defaults to the webProtocol value").build());
            options.addOption(Option.builder().longOpt("announcedWebHost").hasArg().desc("The hostname or IP address that is to be used by the end users (when different from webHost). Defaults to the webHost address. ").build());
            options.addOption(Option.builder().longOpt("announcedWebPort").hasArg().desc("The TCP port number that is to be used by the end users (when different from webPort). Defaults to the webPort value.").type(Integer.class).build());
            options.addOption(Option.builder().longOpt("announcedWebContextRoot").hasArg().desc("The context root that is to be used by the end users (when different from webContextRoot). Defaults to webContextRoot value.").build());
            options.addOption(Option.builder().longOpt("xmppHost").hasArg().desc("The FQDN or IP address (not XMPP domain name) of the XMPP domain that this component will connect to. Defaults to 'localhost'.").build());
            options.addOption(Option.builder().longOpt("xmppPort").hasArg().desc("The TCP port number on the xmppHost, to which a connection will be made. Defaults to 5275.").type(Integer.class).build());
            options.addOption(Option.builder().longOpt("domain").hasArg().desc("The domain that will be used for the component with the XMPP domain.").build());
            options.addOption(Option.builder().longOpt("sharedSecret").hasArg().desc("The shared secret, that authenticates this component with the XMPP domain.").build());
            OptionGroup repoType = new OptionGroup();
            repoType.addOption(Option.builder().longOpt("tempFileRepo").hasArg(false).desc("Store files in the temporary directory provided by the file system.").build());
            repoType.addOption(Option.builder().longOpt("fileRepo").hasArg().desc("Store files in a directory provided by the file system. Provide the desired path as a value. Path must exist.").build());
            options.addOptionGroup(repoType);
            options.addOption(Option.builder().longOpt("maxFileSize").hasArg().desc("The maximum allowed size per file, in bytes. Use -1 to disable file size limit. Defaults to 5242880 (five MB).").optionalArg(true).type(Long.class).build());
            options.addOption(Option.builder().longOpt("wildcardCORS").desc("Add CORS headers that define a liberal access control regime (wildcard origin, various headers and methods).").build());
            options.addOption(Option.builder().longOpt("clamavHost").hasArg().desc("The FQDN or IP address of the host running the optional ClamAV malware scanner, if any.").build());
            options.addOption(Option.builder().longOpt("clamavPort").hasArg().desc("The TCP port number for the optional ClamAV malware scanner, if any.").type(Integer.class).build());
            try {
                AbstractFileSystemRepository repository;
                Integer clamavPort;
                DefaultParser parser = new DefaultParser();
                CommandLine line = parser.parse(options, args);
                if (line.hasOption("h")) {
                    HelpFormatter formatter = new HelpFormatter();
                    formatter.printHelp("arguments", options);
                    break block9;
                }
                String webProtocol = line.getOptionValue("webProtocol");
                String webHost = line.getOptionValue("webHost");
                Integer webPort = line.hasOption("webPort") ? Integer.valueOf(Integer.parseInt(line.getOptionValue("webPort"))) : null;
                String webContextRoot = line.hasOption("webContextRoot") ? line.getOptionValue("webContextRoot") : "/";
                String announcedWebProtocol = line.getOptionValue("announcedWebProtocol");
                String announcedWebHost = line.getOptionValue("announcedWebHost");
                Integer announcedWebPort = line.hasOption("announcedWebPort") ? Integer.valueOf(Integer.parseInt(line.getOptionValue("announcedWebPort"))) : null;
                String announcedWebContextRoot = line.hasOption("announcedWebContextRoot") ? line.getOptionValue("announcedWebContextRoot") : "/";
                String xmppHost = line.getOptionValue("xmppHost");
                Integer xmppPort = line.hasOption("xmppPort") ? Integer.valueOf(Integer.parseInt(line.getOptionValue("xmppPort"))) : null;
                String domain = line.getOptionValue("domain");
                String sharedSecret = line.getOptionValue("sharedSecret");
                Long maxFileSize = line.hasOption("maxFileSize") ? Long.valueOf(Long.parseLong(line.getOptionValue("maxFileSize"))) : null;
                boolean wildcardCORS = line.hasOption("wildcardCORS");
                String clamavHost = line.getOptionValue("clamavHost", null);
                Integer n = clamavPort = line.hasOption("clamavPort") ? Integer.valueOf(Integer.parseInt(line.getOptionValue("clamavPort"))) : null;
                if (line.hasOption("tempFileRepo")) {
                    repository = new TempDirectoryRepository();
                } else if (line.hasOption("fileRepo")) {
                    Path path;
                    String directory = line.getOptionValue("fileRepo");
                    try {
                        path = Paths.get(directory, new String[0]);
                    }
                    catch (InvalidPathException e) {
                        throw new ParseException("Invalid value for 'fileRepo' option: " + e.getMessage());
                    }
                    repository = new DirectoryRepository(path);
                } else {
                    repository = null;
                }
                ClamavMalwareScanner clamav = clamavHost != null ? new ClamavMalwareScanner(clamavHost, clamavPort == null ? 3310 : clamavPort, Duration.ofSeconds(2L)) : null;
                Launcher launcher = new Launcher(xmppHost, xmppPort, domain, sharedSecret, webProtocol, webHost, webPort, webContextRoot, announcedWebProtocol, announcedWebHost, announcedWebPort, announcedWebContextRoot, repository, maxFileSize, wildcardCORS, clamav);
                launcher.start();
            }
            catch (ParseException e) {
                System.err.println("Command line parsing failed: " + e.getMessage());
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("arguments", options);
                System.exit(1);
            }
        }
    }

    private static String getPublicAddress() {
        ArrayDeque<String> hostnames = new ArrayDeque<String>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                if (ni.isLoopback() || ni.isPointToPoint()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress a;
                    InetAddress address = addresses.nextElement();
                    if (address instanceof Inet4Address) {
                        a = (Inet4Address)address;
                        if (((Inet4Address)a).isAnyLocalAddress()) continue;
                        hostnames.addFirst(((Inet4Address)a).getHostAddress());
                    }
                    if (!(address instanceof Inet6Address) || ((Inet6Address)(a = (Inet6Address)address)).isAnyLocalAddress()) continue;
                    hostnames.addLast(((Inet6Address)a).getHostAddress());
                }
            }
        }
        catch (Exception e) {
            Log.warn("An exception occurred while identifying public addresses.", (Throwable)e);
        }
        if (hostnames.isEmpty()) {
            Log.info("Unable to identify a public address.");
            return null;
        }
        Log.info("Public address(es): ");
        for (String address : hostnames) {
            Log.info("* {}", (Object)address);
        }
        return (String)hostnames.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        String local = this.webProtocol + "://" + this.webHost + ":" + this.webPort + this.webContextRoot;
        String announced = this.announcedWebProtocol + "://" + this.announcedWebHost + ":" + this.announcedWebPort + this.announcedWebContextRoot;
        Log.info("Starting external component with HTTP endpoint {} (which is announced as: {})", (Object)local, (Object)announced);
        Log.info("Starting slot manager...");
        SlotManager.getInstance().initialize(this.slotProvider);
        SlotManager.getInstance().setWebProtocol(this.announcedWebProtocol);
        SlotManager.getInstance().setWebHost(this.announcedWebHost);
        SlotManager.getInstance().setWebPort(this.announcedWebPort);
        SlotManager.getInstance().setWebContextRoot(this.announcedWebContextRoot);
        if (this.maxFileSize != null) {
            SlotManager.getInstance().setMaxFileSize(this.maxFileSize);
        }
        Log.info("maxFileSize: {}", (Object)SlotManager.getInstance().getMaxFileSize());
        Server jetty = null;
        ExternalComponentManager manager = null;
        try {
            Log.info("Starting repository...");
            RepositoryManager.getInstance().initialize(this.repository);
            Log.info("Starting malware scanner...");
            MalwareScannerManager.getInstance().initialize(this.malwareScanner);
            Log.info("Starting webserver...");
            jetty = new Server();
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setHost(this.webHost);
            connector.setPort(this.webPort.intValue());
            jetty.addConnector((Connector)connector);
            ServletContextHandler servletContextHandler = new ServletContextHandler();
            servletContextHandler.addServlet(Servlet.class, this.webContextRoot).setInitParameter("wildcardCORS", String.valueOf(this.wildcardCORS));
            jetty.setHandler((Handler)servletContextHandler);
            jetty.start();
            Log.info("Webserver started at {}:{}", (Object)connector.getHost(), (Object)connector.getLocalPort());
            Component component = new Component(this.domain);
            manager = new ExternalComponentManager(this.xmppHost, this.xmppPort.intValue());
            if (this.sharedSecret != null) {
                manager.setSecretKey(this.domain, this.sharedSecret);
            }
            manager.addComponent(this.domain, (org.xmpp.component.Component)component);
            Log.info("External component registered to XMPP domain.");
            Log.info("Ready!");
            try {
                while (true) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException e) {
                try {
                    Log.debug("Shutting down...");
                    if (jetty != null) {
                        jetty.stop();
                    }
                    if (manager != null) {
                        manager.removeComponent(this.domain);
                    }
                    RepositoryManager.getInstance().destroy();
                }
                catch (Exception e2) {
                    Log.error("An unexpected error occurred while shutting down.", (Throwable)e2);
                }
            }
        }
        catch (Exception e) {
            Log.error("An unexpected exception occurred!", (Throwable)e);
        }
        finally {
            try {
                Log.debug("Shutting down...");
                if (jetty != null) {
                    jetty.stop();
                }
                if (manager != null) {
                    manager.removeComponent(this.domain);
                }
                RepositoryManager.getInstance().destroy();
            }
            catch (Exception e) {
                Log.error("An unexpected error occurred while shutting down.", (Throwable)e);
            }
        }
    }
}

