/*
 * Decompiled with CFR 0.152.
 */
package nl.goodbytes.xmpp.xep0363.clamav;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import nl.goodbytes.xmpp.xep0363.MalwareDetectedException;
import nl.goodbytes.xmpp.xep0363.MalwareScanner;
import nl.goodbytes.xmpp.xep0363.RepositoryManager;
import nl.goodbytes.xmpp.xep0363.SecureUniqueId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.capybara.clamav.ClamavClient;
import xyz.capybara.clamav.ClamavException;
import xyz.capybara.clamav.commands.scan.result.ScanResult;

public class ClamavMalwareScanner
implements MalwareScanner {
    private static final Logger Log = LoggerFactory.getLogger(ClamavMalwareScanner.class);
    private final String hostname;
    private final int port;
    private final Duration connectTimeout;
    private ClamavClient client;

    public ClamavMalwareScanner(String hostname, int port, Duration connectTimeout) {
        this.hostname = hostname;
        this.port = port;
        this.connectTimeout = connectTimeout.toMillis() > Integer.MAX_VALUE ? Duration.ofMillis(Integer.MAX_VALUE) : connectTimeout;
    }

    @Override
    public synchronized void initialize() throws IOException {
        this.client = new ClamavClient(this.hostname, this.port);
        if (!this.client.isReachable((int)this.connectTimeout.toMillis())) {
            throw new IOException("Clamav daemon not reachable on " + this.hostname + ":" + this.port);
        }
        try {
            String version = this.client.version();
            Log.info("Successfully connected to Clamav daemon " + version + ".");
        }
        catch (Throwable t) {
            Log.debug("Unable to determine Clamav daemon version.");
            Log.info("Successfully connected to Clamav daemon!");
        }
    }

    @Override
    public synchronized void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scan(SecureUniqueId uuid) throws MalwareDetectedException, IOException {
        ClamavMalwareScanner clamavMalwareScanner = this;
        synchronized (clamavMalwareScanner) {
            try {
                this.client.ping();
            }
            catch (ClamavException e) {
                Log.info("Unsuccessful ping of the Clamav daemon. Trying to re-initialize the client.", (Throwable)e);
                this.initialize();
            }
        }
        try (InputStream is = RepositoryManager.getInstance().getRepository().getInputStream(uuid);){
            ScanResult scanResult = this.client.scan(is);
            if (!(scanResult instanceof ScanResult.OK)) {
                if (scanResult instanceof ScanResult.VirusFound) {
                    ((ScanResult.VirusFound)scanResult).getFoundViruses().values().forEach(malware -> Log.warn("Detected malware in slot '{}': {}", (Object)uuid, malware));
                }
                throw new MalwareDetectedException();
            }
        }
    }
}

