/*
 * Decompiled with CFR 0.152.
 */
package nl.grons.metrics4.scala;

import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.util.control.NonFatal$;

public class Timer {
    private final com.codahale.metrics.Timer metric;

    public Timer(com.codahale.metrics.Timer metric) {
        this.metric = metric;
    }

    public com.codahale.metrics.Timer metric() {
        return this.metric;
    }

    public <A> A time(Function0<A> f) {
        Object object;
        Timer.Context ctx = this.metric().time();
        try {
            object = f.apply();
        }
        finally {
            ctx.stop();
        }
        return (A)object;
    }

    public <A> Future<A> timeFuture(Function0<Future<A>> future, ExecutionContext context) {
        Future future2;
        Timer.Context ctx = this.metric().time();
        try {
            future2 = (Future)future.apply();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = (Throwable)option.get();
                ctx.stop();
                throw ex;
            }
            throw throwable;
        }
        Future f = future2;
        f.onComplete((Function1 & Serializable)_$1 -> ctx.stop(), context);
        return f;
    }

    public <A, B> PartialFunction<A, B> timePF(PartialFunction<A, B> pf) {
        return new PartialFunction<A, B>(pf, this){
            private final PartialFunction pf$1;
            private final Timer $outer;
            {
                this.pf$1 = pf$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                PartialFunction.$init$((PartialFunction)this);
            }

            public Object apply(Object a) {
                Object object;
                Timer.Context ctx = this.$outer.metric().time();
                try {
                    object = this.pf$1.apply(a);
                }
                finally {
                    ctx.stop();
                }
                return object;
            }

            public boolean isDefinedAt(Object a) {
                return this.pf$1.isDefinedAt(a);
            }
        };
    }

    public void update(FiniteDuration duration) {
        this.metric().update(duration.length(), duration.unit());
    }

    public void update(long duration, TimeUnit unit) {
        this.metric().update(duration, unit);
    }

    public Timer.Context timerContext() {
        return this.metric().time();
    }

    public long count() {
        return this.metric().getCount();
    }

    public long max() {
        return this.snapshot().getMax();
    }

    public long min() {
        return this.snapshot().getMin();
    }

    public double mean() {
        return this.snapshot().getMean();
    }

    public double stdDev() {
        return this.snapshot().getStdDev();
    }

    public Snapshot snapshot() {
        return this.metric().getSnapshot();
    }

    public double fifteenMinuteRate() {
        return this.metric().getFifteenMinuteRate();
    }

    public double fiveMinuteRate() {
        return this.metric().getFiveMinuteRate();
    }

    public double meanRate() {
        return this.metric().getMeanRate();
    }

    public double oneMinuteRate() {
        return this.metric().getOneMinuteRate();
    }
}

