/*
 * Decompiled with CFR 0.152.
 */
package nl.grons.metrics4.scala;

import com.codahale.metrics.CachedGauge;
import com.codahale.metrics.DefaultSettableGauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import nl.grons.metrics4.scala.Counter;
import nl.grons.metrics4.scala.DeprecatedMetricBuilder;
import nl.grons.metrics4.scala.DropwizardSettableGaugeWithTimeout;
import nl.grons.metrics4.scala.Gauge;
import nl.grons.metrics4.scala.Histogram;
import nl.grons.metrics4.scala.Meter;
import nl.grons.metrics4.scala.MetricName;
import nl.grons.metrics4.scala.MoreImplicits$;
import nl.grons.metrics4.scala.PushGauge;
import nl.grons.metrics4.scala.PushGaugeWithTimeout;
import nl.grons.metrics4.scala.Timer;
import scala.Function0;
import scala.Function1;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public class MetricBuilder
implements DeprecatedMetricBuilder {
    private final MetricName baseName;
    private final MetricRegistry registry;
    private final AtomicReference<Seq<com.codahale.metrics.Gauge<?>>> gauges;

    public MetricBuilder(MetricName baseName, MetricRegistry registry) {
        this.baseName = baseName;
        this.registry = registry;
        this.gauges = new AtomicReference<SeqOps>(package$.MODULE$.Seq().empty());
    }

    public MetricName baseName() {
        return this.baseName;
    }

    public MetricRegistry registry() {
        return this.registry;
    }

    public <A> Gauge<A> gauge(String name, Function0<A> f) {
        return this.registerAndWrapDwGauge(name, new com.codahale.metrics.Gauge<A>(f){
            private final Function0 f$1;
            {
                this.f$1 = f$4;
            }

            public Object getValue() {
                return this.f$1.apply();
            }
        });
    }

    public <A> Gauge<A> cachedGauge(String name, FiniteDuration timeout, Function0<A> f) {
        return this.registerAndWrapDwGauge(name, (com.codahale.metrics.Gauge<A>)new CachedGauge<A>(timeout, f){
            private final Function0 f$3;
            {
                this.f$3 = f$2;
                super(timeout$1.length(), timeout$1.unit());
            }

            public Object loadValue() {
                return this.f$3.apply();
            }
        });
    }

    private <A> Gauge<A> registerAndWrapDwGauge(String name, com.codahale.metrics.Gauge<A> dwGauge) {
        this.registry().register(this.metricNameFor(name), dwGauge);
        this.trackGauge(dwGauge);
        return new Gauge<A>(dwGauge);
    }

    public <A> PushGauge<A> pushGauge(String name, A startValue) {
        DefaultSettableGauge dwGauge = (DefaultSettableGauge)this.registry().gauge(this.metricNameFor(name), () -> new DefaultSettableGauge(startValue));
        this.trackGauge((com.codahale.metrics.Gauge)dwGauge);
        return new PushGauge(dwGauge);
    }

    public <A> PushGaugeWithTimeout<A> pushGaugeWithTimeout(String name, A defaultValue, FiniteDuration timeout) {
        DropwizardSettableGaugeWithTimeout dwGauge = (DropwizardSettableGaugeWithTimeout)this.registry().gauge(this.metricNameFor(name), () -> new DropwizardSettableGaugeWithTimeout<Object>(timeout, defaultValue));
        this.trackGauge((com.codahale.metrics.Gauge)dwGauge);
        return new PushGaugeWithTimeout(dwGauge);
    }

    private <T> void trackGauge(com.codahale.metrics.Gauge<T> dwGauge) {
        MoreImplicits$.MODULE$.RichAtomicReference(this.gauges).getAndTransform((Function1 & Serializable)_$1 -> (Seq)_$1.$colon$plus((Object)dwGauge));
    }

    public Counter counter(String name) {
        return new Counter(this.registry().counter(this.metricNameFor(name)));
    }

    public Histogram histogram(String name) {
        return new Histogram(this.registry().histogram(this.metricNameFor(name)));
    }

    public Meter meter(String name) {
        return new Meter(this.registry().meter(this.metricNameFor(name)));
    }

    public Timer timer(String name) {
        return new Timer(this.registry().timer(this.metricNameFor(name)));
    }

    public void unregisterGauges() {
        Seq<com.codahale.metrics.Gauge<?>> toUnregister = MoreImplicits$.MODULE$.RichAtomicReference(this.gauges).getAndTransform((Function1 & Serializable)_$2 -> (Seq)package$.MODULE$.Seq().empty());
        this.registry().removeMatching(new MetricFilter(toUnregister){
            private final Seq toUnregister$1;
            {
                this.toUnregister$1 = toUnregister$2;
            }

            public boolean matches(String name, Metric metric) {
                return metric instanceof com.codahale.metrics.Gauge && this.toUnregister$1.contains((Object)metric);
            }
        });
    }

    public String metricNameFor(String name) {
        return this.baseName().append((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name})).name();
    }
}

