/*
 * Decompiled with CFR 0.152.
 */
package nl.grons.sentries.core;

import com.yammer.metrics.Metrics;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import nl.grons.sentries.core.RateLimitExceededException;
import nl.grons.sentries.core.RateLimitExceededException$;
import nl.grons.sentries.support.ChainableSentry;
import nl.grons.sentries.support.MetricsSupport$;
import nl.grons.sentries.support.Sentry;
import nl.grons.sentries.support.Sentry$class;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u0001-\u0011qBU1uK2KW.\u001b;TK:$(/\u001f\u0006\u0003\u0007\u0011\tAaY8sK*\u0011QAB\u0001\tg\u0016tGO]5fg*\u0011q\u0001C\u0001\u0006OJ|gn\u001d\u0006\u0002\u0013\u0005\u0011a\u000e\\\u0002\u0001'\u0011\u0001A\u0002\u0006\u000e\u0011\u00055\u0011R\"\u0001\b\u000b\u0005=\u0001\u0012\u0001\u00027b]\u001eT\u0011!E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0014\u001d\t1qJ\u00196fGR\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u000fM,\b\u000f]8si&\u0011\u0011D\u0006\u0002\u0010\u0007\"\f\u0017N\\1cY\u0016\u001cVM\u001c;ssB\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\tY1kY1mC>\u0013'.Z2u\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013!B8x]\u0016\u0014\bGA\u0012-!\r!sE\u000b\b\u00037\u0015J!A\n\u000f\u0002\rA\u0013X\rZ3g\u0013\tA\u0013FA\u0003DY\u0006\u001c8O\u0003\u0002'9A\u00111\u0006\f\u0007\u0001\t\u0015i\u0003A!\u0001/\u0005\ryF%M\t\u0003_I\u0002\"a\u0007\u0019\n\u0005Eb\"a\u0002(pi\"Lgn\u001a\t\u00037MJ!\u0001\u000e\u000f\u0003\u0007\u0005s\u0017\u0010\u0003\u00057\u0001\t\u0015\r\u0011\"\u00018\u00031\u0011Xm]8ve\u000e,g*Y7f+\u0005A\u0004C\u0001\u0013:\u0013\tQ\u0014F\u0001\u0004TiJLgn\u001a\u0005\ty\u0001\u0011\t\u0011)A\u0005q\u0005i!/Z:pkJ\u001cWMT1nK\u0002B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IaP\u0001\u0005e\u0006$X\r\u0005\u0002\u001c\u0001&\u0011\u0011\t\b\u0002\u0004\u0013:$\b\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\u0002\u001dQLW.Z*qC:l\u0015\u000e\u001c7jgB\u00111$R\u0005\u0003\rr\u0011A\u0001T8oO\")\u0001\n\u0001C\u0001\u0013\u00061A(\u001b8jiz\"RA\u0013'R%N\u0003\"a\u0013\u0001\u000e\u0003\tAQ!I$A\u00025\u0003$A\u0014)\u0011\u0007\u0011:s\n\u0005\u0002,!\u0012)Qf\u0012B\u0001]!)ag\u0012a\u0001q!)ah\u0012a\u0001\u007f!)1i\u0012a\u0001\t\"1Q\u000b\u0001Q\u0001\nY\u000ba\u0001^8lK:\u001c\bCA,_\u001b\u0005A&BA-[\u0003\u0019\tGo\\7jG*\u00111\fX\u0001\u000bG>t7-\u001e:sK:$(BA/\u0011\u0003\u0011)H/\u001b7\n\u0005}C&!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u0004b\u0001\u0001\u0006IAY\u0001\u0017]\u0016DH\u000fV8lK:\u0014V\r\\3bg\u0016l\u0015\u000e\u001c7jgB\u0011qkY\u0005\u0003Ib\u0013!\"\u0011;p[&\u001cGj\u001c8h\u0011\u001d1\u0007A1A\u0005\u0002\u001d\f!b]3oiJLH+\u001f9f+\u0005A\u0007CA\u0007j\u0013\tQd\u0002\u0003\u0004l\u0001\u0001\u0006I\u0001[\u0001\fg\u0016tGO]=UsB,\u0007\u0005C\u0003n\u0001\u0011\u0005a.A\u0003baBd\u00170\u0006\u0002pcR\u0011\u0001o\u001d\t\u0003WE$QA\u001d7C\u00029\u0012\u0011\u0001\u0016\u0005\u0007i2$\t\u0019A;\u0002\u0003I\u00042a\u0007<q\u0013\t9HD\u0001\u0005=Eft\u0017-\\3?\u0011\u0019I\b\u0001)C\u0005u\u0006a\u0011mY9vSJ,Gk\\6f]R\t1\u0010\u0005\u0002\u001cy&\u0011Q\u0010\b\u0002\b\u0005>|G.Z1o\u0011\u0019y\b\u0001\"\u0001\u0002\u0002\u0005)!/Z:fiR\u0011\u00111\u0001\t\u00047\u0005\u0015\u0011bAA\u00049\t!QK\\5u\u0011\u001d\tY\u0001\u0001C\u0005\u0003\u001b\tQbY8ogR\u0014Xo\u0019;OC6,Gc\u0001\u001d\u0002\u0010!A\u0011\u0011CA\u0005\u0001\u0004\t\u0019\"A\u0005oC6,\u0007+\u0019:ugB!1$!\u00069\u0013\r\t9\u0002\b\u0002\u000byI,\u0007/Z1uK\u0012t\u0004")
public class RateLimitSentry
implements ChainableSentry,
ScalaObject {
    private final String resourceName;
    private final int rate;
    private final long timeSpanMillis;
    public final AtomicInteger nl$grons$sentries$core$RateLimitSentry$$tokens;
    private final AtomicLong nextTokenReleaseMillis;
    private final String sentryType;

    @Override
    public Sentry andThen(Sentry s) {
        return Sentry$class.andThen(this, s);
    }

    @Override
    public Sentry compose(Sentry s) {
        return Sentry$class.compose(this, s);
    }

    @Override
    public String resourceName() {
        return this.resourceName;
    }

    @Override
    public String sentryType() {
        return this.sentryType;
    }

    @Override
    public <T> T apply(Function0<T> r) {
        if (this.acquireToken()) {
            return (T)r.apply();
        }
        throw new RateLimitExceededException(this.resourceName(), new StringBuilder().append((Object)"Exceeded rate limit of ").append((Object)BoxesRunTime.boxToInteger((int)this.rate)).append((Object)"/").append((Object)BoxesRunTime.boxToLong((long)this.timeSpanMillis)).append((Object)"ms for ").append((Object)this.resourceName()).toString(), RateLimitExceededException$.MODULE$.init$default$3());
    }

    private boolean acquireToken() {
        boolean bl;
        long nextUpdateMillis = this.nextTokenReleaseMillis.get();
        long now = System.currentTimeMillis();
        if (now > nextUpdateMillis && this.nextTokenReleaseMillis.compareAndSet(nextUpdateMillis, now + this.timeSpanMillis)) {
            this.nl$grons$sentries$core$RateLimitSentry$$tokens.set(this.rate - 1);
            bl = true;
        } else {
            bl = this.nl$grons$sentries$core$RateLimitSentry$$tokens.getAndDecrement() > 0;
        }
        return bl;
    }

    @Override
    public void reset() {
        this.nextTokenReleaseMillis.set(0L);
    }

    private String constructName(Seq<String> nameParts) {
        return ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.resourceName(), this.sentryType()}))).$plus$plus(nameParts, Seq$.MODULE$.canBuildFrom())).mkString(".");
    }

    public RateLimitSentry(Class<?> owner, String resourceName, int rate, long timeSpanMillis) {
        this.resourceName = resourceName;
        this.rate = rate;
        this.timeSpanMillis = timeSpanMillis;
        Sentry$class.$init$(this);
        this.nl$grons$sentries$core$RateLimitSentry$$tokens = new AtomicInteger(rate);
        this.nextTokenReleaseMillis = new AtomicLong(0L);
        this.sentryType = "rateLimit";
        Metrics.newGauge(owner, (String)this.constructName((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"available"})), MetricsSupport$.MODULE$.function0ToGauge(new Serializable(this){
            public static final long serialVersionUID;
            private final RateLimitSentry $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.nl$grons$sentries$core$RateLimitSentry$$tokens.get();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }
}

