/*
 * Decompiled with CFR 0.152.
 */
package nl.grons.sentries.core;

import java.util.concurrent.atomic.AtomicInteger;
import nl.grons.sentries.core.CircuitBreakerBrokenException;
import nl.grons.sentries.core.CircuitBreakerBrokenException$;
import nl.grons.sentries.core.CircuitBreakerSentry;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I<Q!\u0001\u0002\t\u000e-\taa\u0015;bi\u0016\u001c(BA\u0002\u0005\u0003\u0011\u0019wN]3\u000b\u0005\u00151\u0011\u0001C:f]R\u0014\u0018.Z:\u000b\u0005\u001dA\u0011!B4s_:\u001c(\"A\u0005\u0002\u00059d7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tAia\u0004\u0002\u0007'R\fG/Z:\u0014\u00075\u0001\u0002\u0004\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005!A.\u00198h\u0015\u0005)\u0012\u0001\u00026bm\u0006L!a\u0006\n\u0003\r=\u0013'.Z2u!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u000b}iA\u0011\u0001\u0011\u0002\rqJg.\u001b;?)\u0005Ya!\u0002\u0012\u000e\u0003\u0003\u0019#!B*uCR,7cA\u0011\u00111!AQ%\tB\u0001B\u0003%a%\u0001\u0002dEB\u0011AbJ\u0005\u0003Q\t\u0011AcQ5sGVLGO\u0011:fC.,'oU3oiJL\b\"B\u0010\"\t\u0003QCCA\u0016.!\ta\u0013%D\u0001\u000e\u0011\u0015)\u0013\u00061\u0001'\u0011\u0015y\u0013E\"\u00011\u0003%\u0001(/Z%om>\\W\rF\u00012!\tI\"'\u0003\u000245\t!QK\\5u\u0011\u0015)\u0014E\"\u00011\u0003)\u0001xn\u001d;J]Z|7.\u001a\u0005\u0006o\u00052\t\u0001O\u0001\f_:$\u0006N]8xC\ndW\r\u0006\u00022s!)!H\u000ea\u0001w\u0005\tQ\r\u0005\u0002=\t:\u0011QH\u0011\b\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001*\ta\u0001\u0010:p_Rt\u0014\"A\u000e\n\u0005\rS\u0012a\u00029bG.\fw-Z\u0005\u0003\u000b\u001a\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005\rSb\u0001\u0002%\u000e\u0001%\u0013\u0011B\u00127poN#\u0018\r^3\u0014\u0007\u001d[\u0003\u0004\u0003\u0005&\u000f\n\u0005\t\u0015!\u0003'\u0011\u0015yr\t\"\u0001M)\tie\n\u0005\u0002-\u000f\")Qe\u0013a\u0001M!1\u0001k\u0012Q\u0001\nE\u000bABZ1jYV\u0014XmQ8v]R\u0004\"AU-\u000e\u0003MS!\u0001V+\u0002\r\u0005$x.\\5d\u0015\t1v+\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001\u0017\u000b\u0002\tU$\u0018\u000e\\\u0005\u00035N\u0013Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\b\"B\u0018H\t\u0003\u0001\u0004\"B\u001bH\t\u0003\u0001\u0004\"B\u001cH\t\u0003qFCA\u0019`\u0011\u0015QT\f1\u0001<\r\u0011\tW\u0002\u00012\u0003\u0017\t\u0013xn[3o'R\fG/Z\n\u0004A.B\u0002\u0002C\u0013a\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u000b}\u0001G\u0011A3\u0015\u0005\u0019<\u0007C\u0001\u0017a\u0011\u0015)C\r1\u0001'\u0011\u0019I\u0007\r)A\u0005U\u00069!/\u001a;ss\u0006#\bCA\rl\u0013\ta'D\u0001\u0003M_:<\u0007\"B\u0018a\t\u0003\u0001\u0004\"B\u001ba\t\u0003\u0001\u0004\"B\u001ca\t\u0003\u0001HCA\u0019r\u0011\u0015Qt\u000e1\u0001<\u0001")
public final class States {

    public static abstract class State
    implements ScalaObject {
        public abstract void preInvoke();

        public abstract void postInvoke();

        public abstract void onThrowable(Throwable var1);

        public State(CircuitBreakerSentry cb) {
        }
    }

    public static class FlowState
    extends State
    implements ScalaObject {
        private final CircuitBreakerSentry cb;
        private final AtomicInteger failureCount;

        public void preInvoke() {
        }

        public void postInvoke() {
            if (this.failureCount.get() != 0) {
                this.failureCount.set(0);
            }
        }

        public void onThrowable(Throwable e) {
            int currentCount = this.failureCount.incrementAndGet();
            if (currentCount >= this.cb.failLimit()) {
                this.cb.trip();
            }
        }

        public FlowState(CircuitBreakerSentry cb) {
            this.cb = cb;
            super(cb);
            this.failureCount = new AtomicInteger();
        }
    }

    public static class BrokenState
    extends State
    implements ScalaObject {
        private final CircuitBreakerSentry cb;
        private final long retryAt;

        public void preInvoke() {
            boolean retry;
            boolean bl = retry = System.currentTimeMillis() > this.retryAt;
            if (retry && this.cb.attemptResetBrokenState(this)) {
                return;
            }
            throw new CircuitBreakerBrokenException(this.cb.resourceName(), new StringBuilder().append((Object)"Making ").append((Object)this.cb.resourceName()).append((Object)" unavailable after ").append((Object)BoxesRunTime.boxToInteger((int)this.cb.failLimit())).append((Object)" errors").toString(), CircuitBreakerBrokenException$.MODULE$.init$default$3());
        }

        public void postInvoke() {
            this.cb.reset();
        }

        public void onThrowable(Throwable e) {
        }

        public BrokenState(CircuitBreakerSentry cb) {
            this.cb = cb;
            super(cb);
            this.retryAt = System.currentTimeMillis() + cb.retryDelayMillis();
        }
    }
}

