/*
 * Decompiled with CFR 0.152.
 */
package nl.grons.sentries.core;

import akka.util.Duration;
import com.yammer.metrics.Metrics;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import nl.grons.sentries.core.RateLimitExceededException;
import nl.grons.sentries.core.RateLimitExceededException$;
import nl.grons.sentries.support.ChainableSentry;
import nl.grons.sentries.support.MetricsSupport$;
import nl.grons.sentries.support.Sentry$class;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\u0001\u0003\u0001-\u0011qBU1uK2KW.\u001b;TK:$(/\u001f\u0006\u0003\u0007\u0011\tAaY8sK*\u0011QAB\u0001\tg\u0016tGO]5fg*\u0011q\u0001C\u0001\u0006OJ|gn\u001d\u0006\u0002\u0013\u0005\u0011a\u000e\\\u0002\u0001'\u0011\u0001A\u0002\u0006\u000e\u0011\u00055\u0011R\"\u0001\b\u000b\u0005=\u0001\u0012\u0001\u00027b]\u001eT\u0011!E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0014\u001d\t1qJ\u00196fGR\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u000fM,\b\u000f]8si&\u0011\u0011D\u0006\u0002\u0010\u0007\"\f\u0017N\\1cY\u0016\u001cVM\u001c;ssB\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\tY1kY1mC>\u0013'.Z2u\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013!B8x]\u0016\u0014\bGA\u0012-!\r!sE\u000b\b\u00037\u0015J!A\n\u000f\u0002\rA\u0013X\rZ3g\u0013\tA\u0013FA\u0003DY\u0006\u001c8O\u0003\u0002'9A\u00111\u0006\f\u0007\u0001\t\u0015i\u0003A!\u0001/\u0005\ryF%M\t\u0003_I\u0002\"a\u0007\u0019\n\u0005Eb\"a\u0002(pi\"Lgn\u001a\t\u00037MJ!\u0001\u000e\u000f\u0003\u0007\u0005s\u0017\u0010\u0003\u00057\u0001\t\u0015\r\u0011\"\u00018\u00031\u0011Xm]8ve\u000e,g*Y7f+\u0005A\u0004C\u0001\u0013:\u0013\tQ\u0014F\u0001\u0004TiJLgn\u001a\u0005\ty\u0001\u0011\t\u0011)A\u0005q\u0005i!/Z:pkJ\u001cWMT1nK\u0002B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IaP\u0001\u0005e\u0006$X\r\u0005\u0002\u001c\u0001&\u0011\u0011\t\b\u0002\u0004\u0013:$\b\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\u0002\u0011QLW.Z*qC:\u0004\"!R+\u000f\u0005\u0019\u0013fBA$Q\u001d\tAuJ\u0004\u0002J\u001d:\u0011!*T\u0007\u0002\u0017*\u0011AJC\u0001\u0007yI|w\u000e\u001e \n\u0003%I!a\u0002\u0005\n\u0005\u00151\u0011BA)\u0005\u0003\u0015\u0019'o\\:t\u0013\t\u0019F+\u0001\u0006D_:\u001cWO\u001d:f]RT!!\u0015\u0003\n\u0005Y;&\u0001\u0003#ve\u0006$\u0018n\u001c8\u000b\u0005M#\u0006\"B-\u0001\t\u0003Q\u0016A\u0002\u001fj]&$h\bF\u0003\\;\n\u001cG\r\u0005\u0002]\u00015\t!\u0001C\u0003\"1\u0002\u0007a\f\r\u0002`CB\u0019Ae\n1\u0011\u0005-\nG!B\u0017Y\u0005\u0003q\u0003\"\u0002\u001cY\u0001\u0004A\u0004\"\u0002 Y\u0001\u0004y\u0004\"B\"Y\u0001\u0004!\u0005B\u00024\u0001A\u0003%q-\u0001\buS6,7\u000b]1o\u001b&dG.[:\u0011\u0005mA\u0017BA5\u001d\u0005\u0011auN\\4\t\r-\u0004\u0001\u0015!\u0003m\u0003\u0019!xn[3ogB\u0011Q\u000e^\u0007\u0002]*\u0011q\u000e]\u0001\u0007CR|W.[2\u000b\u0005E\u0014\u0018AC2p]\u000e,(O]3oi*\u00111\u000fE\u0001\u0005kRLG.\u0003\u0002v]\ni\u0011\t^8nS\u000eLe\u000e^3hKJDaa\u001e\u0001!\u0002\u0013A\u0018A\u00068fqR$vn[3o%\u0016dW-Y:f\u001b&dG.[:\u0011\u00055L\u0018B\u0001>o\u0005)\tEo\\7jG2{gn\u001a\u0005\by\u0002\u0011\r\u0011\"\u0001~\u0003)\u0019XM\u001c;ssRK\b/Z\u000b\u0002}B\u0011Qb`\u0005\u0003u9Aq!a\u0001\u0001A\u0003%a0A\u0006tK:$(/\u001f+za\u0016\u0004\u0003bBA\u0004\u0001\u0011\u0005\u0011\u0011B\u0001\u0006CB\u0004H._\u000b\u0005\u0003\u0017\ty\u0001\u0006\u0003\u0002\u000e\u0005M\u0001cA\u0016\u0002\u0010\u00119\u0011\u0011CA\u0003\u0005\u0004q#!\u0001+\t\u0013\u0005U\u0011Q\u0001CA\u0002\u0005]\u0011!\u0001:\u0011\u000bm\tI\"!\u0004\n\u0007\u0005mAD\u0001\u0005=Eft\u0017-\\3?\u0011!\ty\u0002\u0001Q\u0005\n\u0005\u0005\u0012\u0001D1dcVL'/\u001a+pW\u0016tGCAA\u0012!\rY\u0012QE\u0005\u0004\u0003Oa\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003W\u0001A\u0011AA\u0017\u0003\u0015\u0011Xm]3u)\t\ty\u0003E\u0002\u001c\u0003cI1!a\r\u001d\u0005\u0011)f.\u001b;\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:\u0005i1m\u001c8tiJ,8\r\u001e(b[\u0016$2\u0001OA\u001e\u0011!\ti$!\u000eA\u0002\u0005}\u0012!\u00038b[\u0016\u0004\u0016M\u001d;t!\u0011Y\u0012\u0011\t\u001d\n\u0007\u0005\rCD\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002")
public class RateLimitSentry
implements ChainableSentry,
ScalaObject {
    private final String resourceName;
    private final int rate;
    private final Duration timeSpan;
    private final long timeSpanMillis;
    public final AtomicInteger nl$grons$sentries$core$RateLimitSentry$$tokens;
    private final AtomicLong nextTokenReleaseMillis;
    private final String sentryType;

    @Override
    public String resourceName() {
        return this.resourceName;
    }

    @Override
    public String sentryType() {
        return this.sentryType;
    }

    @Override
    public <T> T apply(Function0<T> r) {
        if (this.acquireToken()) {
            return (T)r.apply();
        }
        throw new RateLimitExceededException(this.resourceName(), new StringBuilder().append((Object)"Exceeded rate limit of ").append((Object)BoxesRunTime.boxToInteger((int)this.rate)).append((Object)"/").append((Object)this.timeSpan).append((Object)" for ").append((Object)this.resourceName()).toString(), RateLimitExceededException$.MODULE$.init$default$3());
    }

    private boolean acquireToken() {
        boolean bl;
        long nextUpdateMillis = this.nextTokenReleaseMillis.get();
        long now = System.currentTimeMillis();
        if (now > nextUpdateMillis && this.nextTokenReleaseMillis.compareAndSet(nextUpdateMillis, now + this.timeSpanMillis)) {
            this.nl$grons$sentries$core$RateLimitSentry$$tokens.set(this.rate - 1);
            bl = true;
        } else {
            bl = this.nl$grons$sentries$core$RateLimitSentry$$tokens.getAndDecrement() > 0;
        }
        return bl;
    }

    @Override
    public void reset() {
        this.nextTokenReleaseMillis.set(0L);
    }

    private String constructName(Seq<String> nameParts) {
        return ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.resourceName(), this.sentryType()}))).$plus$plus(nameParts, Seq$.MODULE$.canBuildFrom())).mkString(".");
    }

    public RateLimitSentry(Class<?> owner, String resourceName, int rate, Duration timeSpan) {
        this.resourceName = resourceName;
        this.rate = rate;
        this.timeSpan = timeSpan;
        Sentry$class.$init$(this);
        this.timeSpanMillis = timeSpan.toMillis();
        this.nl$grons$sentries$core$RateLimitSentry$$tokens = new AtomicInteger(rate);
        this.nextTokenReleaseMillis = new AtomicLong(0L);
        this.sentryType = "rateLimit";
        Metrics.newGauge(owner, (String)this.constructName((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"available"})), MetricsSupport$.MODULE$.function0ToGauge(new Serializable(this){
            public static final long serialVersionUID;
            private final RateLimitSentry $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.nl$grons$sentries$core$RateLimitSentry$$tokens.get();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }
}

