/*
 * Decompiled with CFR 0.152.
 */
package nl.grons.sentries.core;

import akka.util.Duration;
import com.yammer.metrics.HealthChecks;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.HealthCheck;
import com.yammer.metrics.core.MetricName;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import nl.grons.sentries.core.CircuitBreakerBrokenException;
import nl.grons.sentries.core.CircuitBreakerBrokenException$;
import nl.grons.sentries.support.ChainableSentry;
import nl.grons.sentries.support.MetricsSupport$;
import nl.grons.sentries.support.NotAvailableException;
import nl.grons.sentries.support.Sentry;
import nl.grons.sentries.support.Sentry$class;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.control.ControlThrowable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0001\u0003\u0001-\u0011AcQ5sGVLGO\u0011:fC.,'oU3oiJL(BA\u0002\u0005\u0003\u0011\u0019wN]3\u000b\u0005\u00151\u0011\u0001C:f]R\u0014\u0018.Z:\u000b\u0005\u001dA\u0011!B4s_:\u001c(\"A\u0005\u0002\u00059d7\u0001A\n\u0005\u00011!\"\u0004\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\t)\u0002$D\u0001\u0017\u0015\t9B!A\u0004tkB\u0004xN\u001d;\n\u0005e1\"aD\"iC&t\u0017M\u00197f'\u0016tGO]=\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005)qn\u001e8feB\u00121\u0005\f\t\u0004I\u001dRcBA\u000e&\u0013\t1C$\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q%\u0012Qa\u00117bgNT!A\n\u000f\u0011\u0005-bC\u0002\u0001\u0003\u0006[\u0001\u0011\tA\f\u0002\u0004?\u0012\n\u0014CA\u00183!\tY\u0002'\u0003\u000229\t9aj\u001c;iS:<\u0007CA\u000e4\u0013\t!DDA\u0002B]fD\u0001B\u000e\u0001\u0003\u0006\u0004%\taN\u0001\re\u0016\u001cx.\u001e:dK:\u000bW.Z\u000b\u0002qA\u0011A%O\u0005\u0003u%\u0012aa\u0015;sS:<\u0007\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002\u001bI,7o\\;sG\u0016t\u0015-\\3!\u0011!q\u0004A!b\u0001\n\u0003y\u0014!\u00034bS2d\u0015.\\5u+\u0005\u0001\u0005CA\u000eB\u0013\t\u0011EDA\u0002J]RD\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I\u0001Q\u0001\u000bM\u0006LG\u000eT5nSR\u0004\u0003\u0002\u0003$\u0001\u0005\u000b\u0007I\u0011A$\u0002\u0015I,GO]=EK2\f\u00170F\u0001I!\tI\u0015L\u0004\u0002K-:\u00111\n\u0016\b\u0003\u0019Ns!!\u0014*\u000f\u00059\u000bV\"A(\u000b\u0005AS\u0011A\u0002\u001fs_>$h(C\u0001\n\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u0011Q\u000bB\u0001\u0006GJ|7o]\u0005\u0003/b\u000b!bQ8oGV\u0014(/\u001a8u\u0015\t)F!\u0003\u0002[7\nAA)\u001e:bi&|gN\u0003\u0002X1\"AQ\f\u0001B\u0001B\u0003%\u0001*A\u0006sKR\u0014\u0018\u0010R3mCf\u0004\u0003\"B0\u0001\t\u0003\u0001\u0017A\u0002\u001fj]&$h\bF\u0003bG\"L'\u000e\u0005\u0002c\u00015\t!\u0001C\u0003\"=\u0002\u0007A\r\r\u0002fOB\u0019Ae\n4\u0011\u0005-:G!B\u0017_\u0005\u0003q\u0003\"\u0002\u001c_\u0001\u0004A\u0004\"\u0002 _\u0001\u0004\u0001\u0005\"\u0002$_\u0001\u0004A\u0005b\u00027\u0001\u0005\u0004%\t!\\\u0001\u000bg\u0016tGO]=UsB,W#\u00018\u0011\u00055y\u0017B\u0001\u001e\u000f\u0011\u0019\t\b\u0001)A\u0005]\u0006Y1/\u001a8uef$\u0016\u0010]3!\u0011\u0019\u0019\b\u0001)A\u0005i\u0006)1\u000f^1uKB\u0019Q\u000f @\u000e\u0003YT!a\u001e=\u0002\r\u0005$x.\\5d\u0015\tI(0\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u001f\t\u0002\tU$\u0018\u000e\\\u0005\u0003{Z\u0014q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\u0004\u007f\u0006=ab\u00012\u0002\u0002\u001d9\u00111\u0001\u0002\t\u000e\u0005\u0015\u0011\u0001F\"je\u000e,\u0018\u000e\u001e\"sK\u0006\\WM]*f]R\u0014\u0018\u0010E\u0002c\u0003\u000f1a!\u0001\u0002\t\u000e\u0005%1\u0003BA\u0004\u0019iAqaXA\u0004\t\u0003\ti\u0001\u0006\u0002\u0002\u0006\u0019A\u0011\u0011CA\u0004\u0003\u0003\t\u0019BA\u0003Ti\u0006$Xm\u0005\u0003\u0002\u00101Q\u0002BCA\f\u0003\u001f\u0011\t\u0011)A\u0005C\u0006\u00111M\u0019\u0005\b?\u0006=A\u0011AA\u000e)\u0011\ti\"!\t\u0011\t\u0005}\u0011qB\u0007\u0003\u0003\u000fAq!a\u0006\u0002\u001a\u0001\u0007\u0011\r\u0003\u0005\u0002&\u0005=a\u0011AA\u0014\u0003%\u0001(/Z%om>\\W\r\u0006\u0002\u0002*A\u00191$a\u000b\n\u0007\u00055BD\u0001\u0003V]&$\b\u0002CA\u0019\u0003\u001f1\t!a\n\u0002\u0015A|7\u000f^%om>\\W\r\u0003\u0005\u00026\u0005=a\u0011AA\u001c\u0003-yg\u000e\u00165s_^\f'\r\\3\u0015\t\u0005%\u0012\u0011\b\u0005\t\u0003w\t\u0019\u00041\u0001\u0002>\u0005\tQ\r\u0005\u0003\u0002@\u0005%c\u0002BA!\u0003\u000br1ATA\"\u0013\u0005i\u0012bAA$9\u00059\u0001/Y2lC\u001e,\u0017\u0002BA&\u0003\u001b\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005\u001dCDB\u0004\u0002R\u0005\u001d\u0001!a\u0015\u0003\u0013\u0019cwn^*uCR,7#BA(\u0003;Q\u0002BCA\f\u0003\u001f\u0012\t\u0011)A\u0005C\"9q,a\u0014\u0005\u0002\u0005eC\u0003BA.\u0003;\u0002B!a\b\u0002P!9\u0011qCA,\u0001\u0004\t\u0007\"CA1\u0003\u001f\u0002\u000b\u0011BA2\u000311\u0017-\u001b7ve\u0016\u001cu.\u001e8u!\r)\u0018QM\u0005\u0004\u0003O2(!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u0005\u0002&\u0005=C\u0011AA\u0014\u0011!\t\t$a\u0014\u0005\u0002\u0005\u001d\u0002\u0002CA\u001b\u0003\u001f\"\t!a\u001c\u0015\t\u0005%\u0012\u0011\u000f\u0005\t\u0003w\ti\u00071\u0001\u0002>\u00199\u0011QOA\u0004\u0001\u0005]$a\u0003\"s_.,gn\u0015;bi\u0016\u001cR!a\u001d\u0002\u001eiA!\"a\u0006\u0002t\t\u0005\t\u0015!\u0003b\u0011\u001dy\u00161\u000fC\u0001\u0003{\"B!a \u0002\u0002B!\u0011qDA:\u0011\u001d\t9\"a\u001fA\u0002\u0005D\u0011\"!\"\u0002t\u0001\u0006I!a\"\u0002\u000fI,GO]=BiB\u00191$!#\n\u0007\u0005-ED\u0001\u0003M_:<\u0007\u0002CA\u0013\u0003g\"\t!a\n\t\u0011\u0005E\u00121\u000fC\u0001\u0003OA\u0001\"!\u000e\u0002t\u0011\u0005\u00111\u0013\u000b\u0005\u0003S\t)\n\u0003\u0005\u0002<\u0005E\u0005\u0019AA\u001f\u0011\u001d\tI\n\u0001C\u0001\u00037\u000bQ!\u00199qYf,B!!(\u0002\"R!\u0011qTAS!\rY\u0013\u0011\u0015\u0003\b\u0003G\u000b9J1\u0001/\u0005\u0005!\u0006\"CAT\u0003/#\t\u0019AAU\u0003\u0005\u0011\b#B\u000e\u0002,\u0006}\u0015bAAW9\tAAHY=oC6,g\bC\u0004\u00022\u0002!\t!a\n\u0002\tQ\u0014\u0018\u000e\u001d\u0005\b\u0003k\u0003A\u0011AA\u0014\u0003\u0015\u0011Xm]3u\u0011\u001d\tI\f\u0001C\u0001\u0003w\u000bq#\u0019;uK6\u0004HOU3tKR\u0014%o\\6f]N#\u0018\r^3\u0015\t\u0005u\u00161\u0019\t\u00047\u0005}\u0016bAAa9\t9!i\\8mK\u0006t\u0007\u0002CAc\u0003o\u0003\r!a2\u0002\u0019\r,(O]3oiN#\u0018\r^3\u0011\u0007}\f\u0019\bC\u0004\u0002L\u0002!I!!4\u0002\u001b\r|gn\u001d;sk\u000e$h*Y7f)\rA\u0014q\u001a\u0005\t\u0003#\fI\r1\u0001\u0002T\u0006Ia.Y7f!\u0006\u0014Ho\u001d\t\u00057\u0005U\u0007(C\u0002\u0002Xr\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?\u0001")
public class CircuitBreakerSentry
implements ChainableSentry {
    public final Class<?> nl$grons$sentries$core$CircuitBreakerSentry$$owner;
    private final String resourceName;
    private final int failLimit;
    private final Duration retryDelay;
    private final String sentryType;
    public final AtomicReference<State> nl$grons$sentries$core$CircuitBreakerSentry$$state;

    @Override
    public Sentry andThen(Sentry s) {
        return Sentry$class.andThen(this, s);
    }

    @Override
    public Sentry compose(Sentry s) {
        return Sentry$class.compose(this, s);
    }

    @Override
    public String resourceName() {
        return this.resourceName;
    }

    public int failLimit() {
        return this.failLimit;
    }

    public Duration retryDelay() {
        return this.retryDelay;
    }

    @Override
    public String sentryType() {
        return this.sentryType;
    }

    @Override
    public <T> T apply(Function0<T> r) {
        this.nl$grons$sentries$core$CircuitBreakerSentry$$state.get().preInvoke();
        Object exceptionResult1 = null;
        try {
            Object ret = r.apply();
            this.nl$grons$sentries$core$CircuitBreakerSentry$$state.get().postInvoke();
            exceptionResult1 = ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof NotAvailableException) {
                throw (NotAvailableException)throwable2;
            }
            if (throwable2 instanceof ControlThrowable) {
                this.nl$grons$sentries$core$CircuitBreakerSentry$$state.get().postInvoke();
                throw (Throwable)((ControlThrowable)throwable2);
            }
            if (throwable2 != null) {
                Throwable e = throwable2;
                this.nl$grons$sentries$core$CircuitBreakerSentry$$state.get().onThrowable(e);
                throw e;
            }
            throw new MatchError((Object)throwable2);
        }
        return (T)exceptionResult1;
    }

    public void trip() {
        this.nl$grons$sentries$core$CircuitBreakerSentry$$state.set(new BrokenState(this));
    }

    @Override
    public void reset() {
        this.nl$grons$sentries$core$CircuitBreakerSentry$$state.set(new FlowState(this));
    }

    public boolean attemptResetBrokenState(BrokenState currentState) {
        return this.nl$grons$sentries$core$CircuitBreakerSentry$$state.compareAndSet(currentState, new BrokenState(this));
    }

    public final String nl$grons$sentries$core$CircuitBreakerSentry$$constructName(Seq<String> nameParts) {
        return ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.resourceName(), this.sentryType()}))).$plus$plus(nameParts, Seq$.MODULE$.canBuildFrom())).mkString(".");
    }

    public CircuitBreakerSentry(Class<?> owner, String resourceName, int failLimit, Duration retryDelay) {
        this.nl$grons$sentries$core$CircuitBreakerSentry$$owner = owner;
        this.resourceName = resourceName;
        this.failLimit = failLimit;
        this.retryDelay = retryDelay;
        Sentry$class.$init$(this);
        this.sentryType = "failLimit";
        this.nl$grons$sentries$core$CircuitBreakerSentry$$state = new AtomicReference<FlowState>(new FlowState(this));
        HealthChecks.register((HealthCheck)new HealthCheck(this){
            private final CircuitBreakerSentry $outer;

            public HealthCheck.Result check() {
                State state = this.$outer.nl$grons$sentries$core$CircuitBreakerSentry$$state.get();
                return state instanceof FlowState ? HealthCheck.Result.healthy() : (state instanceof BrokenState ? HealthCheck.Result.unhealthy((String)"broken") : HealthCheck.Result.unhealthy((String)"unknown state"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(new MetricName($outer.nl$grons$sentries$core$CircuitBreakerSentry$$owner, $outer.nl$grons$sentries$core$CircuitBreakerSentry$$constructName((Seq<String>)Nil$.MODULE$)).getMBeanName());
            }
        });
        State state = this.nl$grons$sentries$core$CircuitBreakerSentry$$state.get();
        Metrics.newGauge(owner, (String)this.nl$grons$sentries$core$CircuitBreakerSentry$$constructName((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"state"})), state instanceof FlowState ? MetricsSupport$.MODULE$.function0ToGauge(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "flow";
            }
        }) : (state instanceof BrokenState ? MetricsSupport$.MODULE$.function0ToGauge(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "broken";
            }
        }) : MetricsSupport$.MODULE$.function0ToGauge(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "unknown";
            }
        })));
    }

    public static abstract class State
    implements ScalaObject {
        public abstract void preInvoke();

        public abstract void postInvoke();

        public abstract void onThrowable(Throwable var1);

        public State(CircuitBreakerSentry cb) {
        }
    }

    public static class FlowState
    extends State
    implements ScalaObject {
        private final CircuitBreakerSentry cb;
        private final AtomicInteger failureCount;

        public void preInvoke() {
        }

        public void postInvoke() {
            if (this.failureCount.get() != 0) {
                this.failureCount.set(0);
            }
        }

        public void onThrowable(Throwable e) {
            int currentCount = this.failureCount.incrementAndGet();
            if (currentCount >= this.cb.failLimit()) {
                this.cb.trip();
            }
        }

        public FlowState(CircuitBreakerSentry cb) {
            this.cb = cb;
            super(cb);
            this.failureCount = new AtomicInteger();
        }
    }

    public static class BrokenState
    extends State
    implements ScalaObject {
        private final CircuitBreakerSentry cb;
        private final long retryAt;

        public void preInvoke() {
            boolean retry;
            boolean bl = retry = System.currentTimeMillis() > this.retryAt;
            if (retry && this.cb.attemptResetBrokenState(this)) {
                return;
            }
            throw new CircuitBreakerBrokenException(this.cb.resourceName(), new StringBuilder().append((Object)"Making ").append((Object)this.cb.resourceName()).append((Object)" unavailable after ").append((Object)BoxesRunTime.boxToInteger((int)this.cb.failLimit())).append((Object)" errors").toString(), CircuitBreakerBrokenException$.MODULE$.init$default$3());
        }

        public void postInvoke() {
            this.cb.reset();
        }

        public void onThrowable(Throwable e) {
        }

        public BrokenState(CircuitBreakerSentry cb) {
            this.cb = cb;
            super(cb);
            this.retryAt = System.currentTimeMillis() + cb.retryDelay().toMillis();
        }
    }
}

