/*
 * Decompiled with CFR 0.152.
 */
package nl.grons.sentries.core;

import com.yammer.metrics.Metrics;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import nl.grons.sentries.core.RateLimitExceededException;
import nl.grons.sentries.core.RateLimitExceededException$;
import nl.grons.sentries.support.ChainableSentry;
import nl.grons.sentries.support.MetricsSupport$;
import nl.grons.sentries.support.Sentry;
import nl.grons.sentries.support.Sentry$class;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u0001-\u0011qBU1uK2KW.\u001b;TK:$(/\u001f\u0006\u0003\u0007\u0011\tAaY8sK*\u0011QAB\u0001\tg\u0016tGO]5fg*\u0011q\u0001C\u0001\u0006OJ|gn\u001d\u0006\u0002\u0013\u0005\u0011a\u000e\\\u0002\u0001'\u0011\u0001A\u0002\u0006\u000e\u0011\u00055\u0011R\"\u0001\b\u000b\u0005=\u0001\u0012\u0001\u00027b]\u001eT\u0011!E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0014\u001d\t1qJ\u00196fGR\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u000fM,\b\u000f]8si&\u0011\u0011D\u0006\u0002\u0010\u0007\"\f\u0017N\\1cY\u0016\u001cVM\u001c;ssB\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\tY1kY1mC>\u0013'.Z2u\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013!B8x]\u0016\u0014\bGA\u0012-!\r!sE\u000b\b\u00037\u0015J!A\n\u000f\u0002\rA\u0013X\rZ3g\u0013\tA\u0013FA\u0003DY\u0006\u001c8O\u0003\u0002'9A\u00111\u0006\f\u0007\u0001\t%i\u0003!!A\u0001\u0002\u000b\u0005aFA\u0002`IE\n\"a\f\u001a\u0011\u0005m\u0001\u0014BA\u0019\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aG\u001a\n\u0005Qb\"aA!os\"Aa\u0007\u0001BC\u0002\u0013\u0005q'\u0001\u0007sKN|WO]2f\u001d\u0006lW-F\u00019!\t!\u0013(\u0003\u0002;S\t11\u000b\u001e:j]\u001eD\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001\u000ee\u0016\u001cx.\u001e:dK:\u000bW.\u001a\u0011\t\u0011y\u0002!\u0011!Q\u0001\n}\nAA]1uKB\u00111\u0004Q\u0005\u0003\u0003r\u00111!\u00138u\u0011!\u0019\u0005A!A!\u0002\u0013!\u0015A\u0004;j[\u0016\u001c\u0006/\u00198NS2d\u0017n\u001d\t\u00037\u0015K!A\u0012\u000f\u0003\t1{gn\u001a\u0005\u0006\u0011\u0002!\t!S\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b)c\u0015KU*\u0011\u0005-\u0003Q\"\u0001\u0002\t\u000b\u0005:\u0005\u0019A'1\u00059\u0003\u0006c\u0001\u0013(\u001fB\u00111\u0006\u0015\u0003\n[\u001d\u000b\t\u0011!A\u0003\u00029BQAN$A\u0002aBQAP$A\u0002}BQaQ$A\u0002\u0011Ca!\u0016\u0001!\u0002\u00131\u0016A\u0002;pW\u0016t7\u000f\u0005\u0002X=6\t\u0001L\u0003\u0002Z5\u00061\u0011\r^8nS\u000eT!a\u0017/\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002^!\u0005!Q\u000f^5m\u0013\ty\u0006LA\u0007Bi>l\u0017nY%oi\u0016<WM\u001d\u0005\u0007C\u0002\u0001\u000b\u0011\u00022\u0002-9,\u0007\u0010\u001e+pW\u0016t'+\u001a7fCN,W*\u001b7mSN\u0004\"aV2\n\u0005\u0011D&AC!u_6L7\rT8oO\"9a\r\u0001b\u0001\n\u00039\u0017AC:f]R\u0014\u0018\u0010V=qKV\t\u0001\u000e\u0005\u0002\u000eS&\u0011!H\u0004\u0005\u0007W\u0002\u0001\u000b\u0011\u00025\u0002\u0017M,g\u000e\u001e:z)f\u0004X\r\t\u0005\u0006[\u0002!\tA\\\u0001\u0006CB\u0004H._\u000b\u0003_F$\"\u0001]:\u0011\u0005-\nH!\u0002:m\u0005\u0004q#!\u0001+\t\rQdG\u00111\u0001v\u0003\u0005\u0011\bcA\u000ewa&\u0011q\u000f\b\u0002\ty\tLh.Y7f}!1\u0011\u0010\u0001Q\u0005\ni\fA\"Y2rk&\u0014X\rV8lK:$\u0012a\u001f\t\u00037qL!! \u000f\u0003\u000f\t{w\u000e\\3b]\"1q\u0010\u0001C\u0001\u0003\u0003\tQA]3tKR$\"!a\u0001\u0011\u0007m\t)!C\u0002\u0002\bq\u0011A!\u00168ji\"9\u00111\u0002\u0001\u0005\n\u00055\u0011!D2p]N$(/^2u\u001d\u0006lW\rF\u00029\u0003\u001fA\u0001\"!\u0005\u0002\n\u0001\u0007\u00111C\u0001\n]\u0006lW\rU1siN\u0004BaGA\u000bq%\u0019\u0011q\u0003\u000f\u0003\u0015q\u0012X\r]3bi\u0016$g\b")
public class RateLimitSentry
implements ChainableSentry {
    private final String resourceName;
    private final int rate;
    private final long timeSpanMillis;
    public final AtomicInteger nl$grons$sentries$core$RateLimitSentry$$tokens;
    private final AtomicLong nextTokenReleaseMillis;
    private final String sentryType;

    @Override
    public Sentry andThen(Sentry s) {
        return Sentry$class.andThen(this, s);
    }

    @Override
    public Sentry compose(Sentry s) {
        return Sentry$class.compose(this, s);
    }

    @Override
    public String resourceName() {
        return this.resourceName;
    }

    @Override
    public String sentryType() {
        return this.sentryType;
    }

    @Override
    public <T> T apply(Function0<T> r) {
        if (this.acquireToken()) {
            return (T)r.apply();
        }
        throw new RateLimitExceededException(this.resourceName(), new StringBuilder().append((Object)"Exceeded rate limit of ").append((Object)BoxesRunTime.boxToInteger((int)this.rate)).append((Object)"/").append((Object)BoxesRunTime.boxToLong((long)this.timeSpanMillis)).append((Object)"ms for ").append((Object)this.resourceName()).toString(), RateLimitExceededException$.MODULE$.init$default$3());
    }

    private boolean acquireToken() {
        boolean bl;
        long nextUpdateMillis = this.nextTokenReleaseMillis.get();
        long now = System.currentTimeMillis();
        if (now > nextUpdateMillis && this.nextTokenReleaseMillis.compareAndSet(nextUpdateMillis, now + this.timeSpanMillis)) {
            this.nl$grons$sentries$core$RateLimitSentry$$tokens.set(this.rate - 1);
            bl = true;
        } else {
            bl = this.nl$grons$sentries$core$RateLimitSentry$$tokens.getAndDecrement() > 0;
        }
        return bl;
    }

    @Override
    public void reset() {
        this.nextTokenReleaseMillis.set(0L);
    }

    private String constructName(Seq<String> nameParts) {
        return ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.resourceName(), this.sentryType()}))).$plus$plus(nameParts, Seq$.MODULE$.canBuildFrom())).mkString(".");
    }

    public RateLimitSentry(Class<?> owner, String resourceName, int rate, long timeSpanMillis) {
        this.resourceName = resourceName;
        this.rate = rate;
        this.timeSpanMillis = timeSpanMillis;
        Sentry$class.$init$(this);
        this.nl$grons$sentries$core$RateLimitSentry$$tokens = new AtomicInteger(rate);
        this.nextTokenReleaseMillis = new AtomicLong(0L);
        this.sentryType = "rateLimit";
        Metrics.newGauge(owner, (String)this.constructName((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"available"})), MetricsSupport$.MODULE$.function0ToGauge(new Serializable(this){
            public static final long serialVersionUID;
            private final RateLimitSentry $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.nl$grons$sentries$core$RateLimitSentry$$tokens.get();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }
}

