/*
 * Decompiled with CFR 0.152.
 */
package nl.grons.sentries.core;

import akka.util.Duration;
import com.yammer.metrics.Metrics;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import nl.grons.sentries.core.RateLimitExceededException;
import nl.grons.sentries.core.RateLimitExceededException$;
import nl.grons.sentries.support.ChainableSentry;
import nl.grons.sentries.support.MetricsSupport$;
import nl.grons.sentries.support.Sentry;
import nl.grons.sentries.support.Sentry$class;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\u0001\u0003\u0001-\u0011qBU1uK2KW.\u001b;TK:$(/\u001f\u0006\u0003\u0007\u0011\tAaY8sK*\u0011QAB\u0001\tg\u0016tGO]5fg*\u0011q\u0001C\u0001\u0006OJ|gn\u001d\u0006\u0002\u0013\u0005\u0011a\u000e\\\u0002\u0001'\u0011\u0001A\u0002\u0006\u000e\u0011\u00055\u0011R\"\u0001\b\u000b\u0005=\u0001\u0012\u0001\u00027b]\u001eT\u0011!E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0014\u001d\t1qJ\u00196fGR\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u000fM,\b\u000f]8si&\u0011\u0011D\u0006\u0002\u0010\u0007\"\f\u0017N\\1cY\u0016\u001cVM\u001c;ssB\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\tY1kY1mC>\u0013'.Z2u\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013!B8x]\u0016\u0014\bGA\u0012-!\r!sE\u000b\b\u00037\u0015J!A\n\u000f\u0002\rA\u0013X\rZ3g\u0013\tA\u0013FA\u0003DY\u0006\u001c8O\u0003\u0002'9A\u00111\u0006\f\u0007\u0001\t%i\u0003!!A\u0001\u0002\u000b\u0005aFA\u0002`IE\n\"a\f\u001a\u0011\u0005m\u0001\u0014BA\u0019\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aG\u001a\n\u0005Qb\"aA!os\"Aa\u0007\u0001BC\u0002\u0013\u0005q'\u0001\u0007sKN|WO]2f\u001d\u0006lW-F\u00019!\t!\u0013(\u0003\u0002;S\t11\u000b\u001e:j]\u001eD\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001\u000ee\u0016\u001cx.\u001e:dK:\u000bW.\u001a\u0011\t\u0011y\u0002!\u0011!Q\u0001\n}\nAA]1uKB\u00111\u0004Q\u0005\u0003\u0003r\u00111!\u00138u\u0011!\u0019\u0005A!A!\u0002\u0013!\u0015\u0001\u0003;j[\u0016\u001c\u0006/\u00198\u0011\u0005\u0015+fB\u0001$S\u001d\t9\u0005K\u0004\u0002I\u001f:\u0011\u0011J\u0014\b\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019*\ta\u0001\u0010:p_Rt\u0014\"A\u0005\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\tF!A\u0003de>\u001c8/\u0003\u0002T)\u0006Q1i\u001c8dkJ\u0014XM\u001c;\u000b\u0005E#\u0011B\u0001,X\u0005!!UO]1uS>t'BA*U\u0011\u0015I\u0006\u0001\"\u0001[\u0003\u0019a\u0014N\\5u}Q)1,\u00182dIB\u0011A\fA\u0007\u0002\u0005!)\u0011\u0005\u0017a\u0001=B\u0012q,\u0019\t\u0004I\u001d\u0002\u0007CA\u0016b\t%i\u0003,!A\u0001\u0002\u000b\u0005a\u0006C\u000371\u0002\u0007\u0001\bC\u0003?1\u0002\u0007q\bC\u0003D1\u0002\u0007A\t\u0003\u0004g\u0001\u0001\u0006IaZ\u0001\u000fi&lWm\u00159b]6KG\u000e\\5t!\tY\u0002.\u0003\u0002j9\t!Aj\u001c8h\u0011\u0019Y\u0007\u0001)A\u0005Y\u00061Ao\\6f]N\u0004\"!\u001c;\u000e\u00039T!a\u001c9\u0002\r\u0005$x.\\5d\u0015\t\t(/\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u001d\t\u0002\tU$\u0018\u000e\\\u0005\u0003k:\u0014Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\bBB<\u0001A\u0003%\u00010\u0001\foKb$Hk\\6f]J+G.Z1tK6KG\u000e\\5t!\ti\u00170\u0003\u0002{]\nQ\u0011\t^8nS\u000eduN\\4\t\u000fq\u0004!\u0019!C\u0001{\u0006Q1/\u001a8uef$\u0016\u0010]3\u0016\u0003y\u0004\"!D@\n\u0005ir\u0001bBA\u0002\u0001\u0001\u0006IA`\u0001\fg\u0016tGO]=UsB,\u0007\u0005C\u0004\u0002\b\u0001!\t!!\u0003\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\u0005-\u0011q\u0002\u000b\u0005\u0003\u001b\t\u0019\u0002E\u0002,\u0003\u001f!q!!\u0005\u0002\u0006\t\u0007aFA\u0001U\u0011%\t)\"!\u0002\u0005\u0002\u0004\t9\"A\u0001s!\u0015Y\u0012\u0011DA\u0007\u0013\r\tY\u0002\b\u0002\ty\tLh.Y7f}!A\u0011q\u0004\u0001!\n\u0013\t\t#\u0001\u0007bGF,\u0018N]3U_.,g\u000e\u0006\u0002\u0002$A\u00191$!\n\n\u0007\u0005\u001dBDA\u0004C_>dW-\u00198\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.\u0005)!/Z:fiR\u0011\u0011q\u0006\t\u00047\u0005E\u0012bAA\u001a9\t!QK\\5u\u0011\u001d\t9\u0004\u0001C\u0005\u0003s\tQbY8ogR\u0014Xo\u0019;OC6,Gc\u0001\u001d\u0002<!A\u0011QHA\u001b\u0001\u0004\ty$A\u0005oC6,\u0007+\u0019:ugB!1$!\u00119\u0013\r\t\u0019\u0005\b\u0002\u000byI,\u0007/Z1uK\u0012t\u0004")
public class RateLimitSentry
implements ChainableSentry {
    private final String resourceName;
    private final int rate;
    private final Duration timeSpan;
    private final long timeSpanMillis;
    public final AtomicInteger nl$grons$sentries$core$RateLimitSentry$$tokens;
    private final AtomicLong nextTokenReleaseMillis;
    private final String sentryType;

    @Override
    public Sentry andThen(Sentry s) {
        return Sentry$class.andThen(this, s);
    }

    @Override
    public Sentry compose(Sentry s) {
        return Sentry$class.compose(this, s);
    }

    @Override
    public String resourceName() {
        return this.resourceName;
    }

    @Override
    public String sentryType() {
        return this.sentryType;
    }

    @Override
    public <T> T apply(Function0<T> r) {
        if (this.acquireToken()) {
            return (T)r.apply();
        }
        throw new RateLimitExceededException(this.resourceName(), new StringBuilder().append((Object)"Exceeded rate limit of ").append((Object)BoxesRunTime.boxToInteger((int)this.rate)).append((Object)"/").append((Object)this.timeSpan).append((Object)" for ").append((Object)this.resourceName()).toString(), RateLimitExceededException$.MODULE$.init$default$3());
    }

    private boolean acquireToken() {
        boolean bl;
        long nextUpdateMillis = this.nextTokenReleaseMillis.get();
        long now = System.currentTimeMillis();
        if (now > nextUpdateMillis && this.nextTokenReleaseMillis.compareAndSet(nextUpdateMillis, now + this.timeSpanMillis)) {
            this.nl$grons$sentries$core$RateLimitSentry$$tokens.set(this.rate - 1);
            bl = true;
        } else {
            bl = this.nl$grons$sentries$core$RateLimitSentry$$tokens.getAndDecrement() > 0;
        }
        return bl;
    }

    @Override
    public void reset() {
        this.nextTokenReleaseMillis.set(0L);
    }

    private String constructName(Seq<String> nameParts) {
        return ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.resourceName(), this.sentryType()}))).$plus$plus(nameParts, Seq$.MODULE$.canBuildFrom())).mkString(".");
    }

    public RateLimitSentry(Class<?> owner, String resourceName, int rate, Duration timeSpan) {
        this.resourceName = resourceName;
        this.rate = rate;
        this.timeSpan = timeSpan;
        Sentry$class.$init$(this);
        this.timeSpanMillis = timeSpan.toMillis();
        this.nl$grons$sentries$core$RateLimitSentry$$tokens = new AtomicInteger(rate);
        this.nextTokenReleaseMillis = new AtomicLong(0L);
        this.sentryType = "rateLimit";
        Metrics.newGauge(owner, (String)this.constructName((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"available"})), MetricsSupport$.MODULE$.function0ToGauge(new Serializable(this){
            public static final long serialVersionUID;
            private final RateLimitSentry $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.nl$grons$sentries$core$RateLimitSentry$$tokens.get();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }
}

