/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.deploy.agent;

import io.vertx.core.json.JsonObject;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import nl.jpoint.vertx.deploy.agent.AwsDeployApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployConfig {
    private static final Logger LOG = LoggerFactory.getLogger(AwsDeployApplication.class);
    private static final String MAVEN_CENTRAL = "https://repo1.maven.org/maven/";
    private static final String DEFAULT_SERVICE_CONFIG_LOCATION = "/etc/default/";
    private static final String VERTX_HOME = "vertx.home";
    private static final String RUN_DIR = "vertx.run";
    private static final String ARTIFACT_REPO = "artifact.storage";
    private static final String AWS_ENABLED = "aws.enable";
    private static final String AWS_REGION = "aws.region";
    private static final String AWS_DEFAULT_REGION = "eu-west-1";
    private static final String AWS_REGISTER_MAX_DURATION = "aws.as.register.maxduration";
    private static final String CONFIG_LOCATION = "config.location";
    private static final String SERVICE_CONFIG_LOCATION = "service.config.location";
    private static final String HTTP_AUTH_USER = "http.authUser";
    private static final String HTTP_PORT = "http.port";
    private static final String HTTP_AUTH_PASS = "http.authPass";
    private static final String MAVEN_REPO_URI = "maven.repo.uri";
    private static final String MAVEN_SNAPSHOT_POLICY = "maven.repo.snapshot.policy";
    private static final String CLUSTER = "vertx.clustering";
    private static final String DEFAULT_JAVA_OPTS = "vertx.default.java.opts";
    private static final String AWS_AS_AUTODISCOVER = "aws.as.autodiscover";
    private static final String AUTH_TOKEN = "auth.token";
    private static final String AWS_INSTANCE_ID = "aws.elb.instanceid";
    private static final String STAT_FILE = ".initial";
    private final Path vertxHome;
    private final Path artifactRepo;
    private final URI nexusUrl;
    private String configLocation;
    private String awsRegion;
    private Integer httpPort;
    private String httpAuthUser;
    private String httpAuthPassword;
    private boolean awsEnabled = false;
    private boolean httpAuthentication = false;
    private boolean mavenRemote = true;
    private String awsLoadbalancerId;
    private int awsMaxRegistrationDuration;
    private String authToken;
    private boolean asCluster = true;
    private String remoteRepoPolicy;
    private String defaultJavaOpts;
    private String runDir;
    private String statFile;
    private boolean awsAutoDiscover = false;
    private String serviceConfigLocation;

    private DeployConfig(String vertxHome, String artifactRepo, String nexusUrl) {
        this.vertxHome = Paths.get(vertxHome, new String[0]);
        this.artifactRepo = Paths.get(artifactRepo, new String[0]);
        if (nexusUrl == null || nexusUrl.isEmpty()) {
            this.mavenRemote = false;
            this.nexusUrl = null;
        } else {
            this.mavenRemote = true;
            this.nexusUrl = URI.create(nexusUrl);
        }
    }

    private static String validateRequiredField(String field, JsonObject config) {
        if (!config.containsKey(field) || config.getString(field).isEmpty()) {
            LOG.error("config missing config value for field {} ", (Object)field);
            throw new IllegalStateException("config missing config value for field " + field);
        }
        return (String)config.remove(field);
    }

    private static <T> T validateField(String field, JsonObject config) {
        return DeployConfig.validateField(field, config, null);
    }

    private static <T> T validateField(String field, JsonObject config, T defaultValue) {
        if (config.containsKey(field) && config.getValue(field) != null) {
            return (T)config.remove(field);
        }
        return defaultValue;
    }

    static DeployConfig fromJsonObject(JsonObject config) {
        if (config == null) {
            LOG.error("Unable to read config file");
            throw new IllegalStateException("Unable to read config file");
        }
        String vertxHome = DeployConfig.validateRequiredField(VERTX_HOME, config);
        String artifactRepo = DeployConfig.validateRequiredField(ARTIFACT_REPO, config);
        String mavenRepo = DeployConfig.validateField(MAVEN_REPO_URI, config, "");
        if (mavenRepo.isEmpty()) {
            LOG.warn("'maven.repo.uri', using maven central");
            mavenRepo = MAVEN_CENTRAL;
        }
        DeployConfig deployconfig = new DeployConfig(vertxHome, artifactRepo, mavenRepo).withConfigLocation(config).withServiceConfigLocation(config).withHttpPort(config).withAwsConfig(config).withHttpAuth(config).withAuthToken(config).withCluster(config).withRunDir(config).withLoggerFactoryName(config).withRemoteRepoUpdatePolicy(config);
        if (!config.isEmpty()) {
            config.fieldNames().forEach(s -> LOG.info("Unused variable in config '{}',", s));
        }
        return deployconfig;
    }

    private DeployConfig withAuthToken(JsonObject config) {
        this.authToken = (String)DeployConfig.validateField(AUTH_TOKEN, config);
        return this;
    }

    private DeployConfig withConfigLocation(JsonObject config) {
        this.configLocation = config.getString(CONFIG_LOCATION, "");
        config.remove(CONFIG_LOCATION);
        return this;
    }

    private DeployConfig withServiceConfigLocation(JsonObject config) {
        this.serviceConfigLocation = config.getString(SERVICE_CONFIG_LOCATION, DEFAULT_SERVICE_CONFIG_LOCATION);
        config.remove(CONFIG_LOCATION);
        return this;
    }

    private DeployConfig withRunDir(JsonObject config) {
        this.runDir = config.getString(RUN_DIR, this.getVertxHome() + "/run/");
        if (!this.runDir.endsWith("/")) {
            this.runDir = this.runDir + "/";
        }
        this.statFile = this.runDir + STAT_FILE;
        config.remove(RUN_DIR);
        return this;
    }

    private DeployConfig withRemoteRepoUpdatePolicy(JsonObject config) {
        this.remoteRepoPolicy = config.getString(MAVEN_SNAPSHOT_POLICY, "always");
        config.remove(MAVEN_SNAPSHOT_POLICY);
        return this;
    }

    private DeployConfig withCluster(JsonObject config) {
        this.asCluster = config.getBoolean(CLUSTER, Boolean.valueOf(true));
        config.remove(CLUSTER);
        return this;
    }

    private DeployConfig withLoggerFactoryName(JsonObject config) {
        this.defaultJavaOpts = config.getString(DEFAULT_JAVA_OPTS, "");
        config.remove(DEFAULT_JAVA_OPTS);
        return this;
    }

    private DeployConfig withAwsConfig(JsonObject config) {
        this.awsRegion = DeployConfig.validateField(AWS_REGION, config, AWS_DEFAULT_REGION);
        this.awsLoadbalancerId = (String)DeployConfig.validateField(AWS_INSTANCE_ID, config);
        this.awsEnabled = DeployConfig.validateField(AWS_ENABLED, config, false);
        this.awsAutoDiscover = DeployConfig.validateField(AWS_AS_AUTODISCOVER, config, false);
        this.awsMaxRegistrationDuration = config.getInteger(AWS_REGISTER_MAX_DURATION, Integer.valueOf(4));
        config.remove(AWS_REGISTER_MAX_DURATION);
        if (this.awsEnabled) {
            LOG.info("Enabled AWS support.");
        } else {
            LOG.info("Disabled AWS support.");
        }
        return this;
    }

    private DeployConfig withHttpAuth(JsonObject config) {
        this.httpAuthUser = DeployConfig.validateField(HTTP_AUTH_USER, config, "");
        this.httpAuthPassword = DeployConfig.validateField(HTTP_AUTH_PASS, config, "");
        if (!this.httpAuthUser.isEmpty() && !this.httpAuthPassword.isEmpty()) {
            LOG.info("Enabled http authentication.");
            this.httpAuthentication = true;
        } else {
            LOG.info("Disabled http authentication.");
        }
        return this;
    }

    private DeployConfig withHttpPort(JsonObject config) {
        this.httpPort = Integer.valueOf(DeployConfig.validateField(HTTP_PORT, config, "6789"));
        return this;
    }

    public Path getVertxHome() {
        return this.vertxHome;
    }

    public Path getArtifactRepo() {
        return this.artifactRepo;
    }

    public URI getNexusUrl() {
        return this.nexusUrl;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public String getAwsLoadbalancerId() {
        return this.awsLoadbalancerId;
    }

    public int getAwsMaxRegistrationDuration() {
        return this.awsMaxRegistrationDuration;
    }

    public String getHttpAuthUser() {
        return this.httpAuthUser;
    }

    public String getHttpAuthPassword() {
        return this.httpAuthPassword;
    }

    public boolean isAwsEnabled() {
        return this.awsEnabled;
    }

    public boolean isHttpAuthentication() {
        return this.httpAuthentication;
    }

    public boolean isMavenRemote() {
        return this.mavenRemote;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public boolean asCluster() {
        return this.asCluster;
    }

    public String getRemoteRepoPolicy() {
        return this.remoteRepoPolicy;
    }

    public String getDefaultJavaOpts() {
        return this.defaultJavaOpts;
    }

    public Integer getHttpPort() {
        return this.httpPort;
    }

    public String getRunDir() {
        return this.runDir;
    }

    public String getStatFile() {
        return this.statFile;
    }

    public boolean isAwsAutoDiscover() {
        return this.awsAutoDiscover;
    }

    public String getServiceConfigLocation() {
        return this.serviceConfigLocation;
    }
}

