/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.deploy.agent.command;

import io.vertx.core.Vertx;
import io.vertx.rxjava.core.buffer.Buffer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import nl.jpoint.vertx.deploy.agent.DeployConfig;
import nl.jpoint.vertx.deploy.agent.command.Command;
import nl.jpoint.vertx.deploy.agent.request.ModuleRequest;
import nl.jpoint.vertx.deploy.agent.util.MetadataXPathUtil;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class ResolveSnapshotVersion<T extends ModuleRequest>
implements Command<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ResolveSnapshotVersion.class);
    private final DeployConfig config;
    private final io.vertx.rxjava.core.Vertx rxVertx;

    public ResolveSnapshotVersion(DeployConfig config, Vertx vertx) {
        this.rxVertx = new io.vertx.rxjava.core.Vertx(vertx);
        this.config = config;
    }

    @Override
    public Observable<T> executeAsync(T request) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.config.getHttpAuthUser(), this.config.getHttpAuthPassword());
        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        URI location = this.config.getNexusUrl().resolve(this.config.getNexusUrl().getPath() + "/" + ((ModuleRequest)request).getMetadataLocation());
        HttpGet get = new HttpGet(location);
        Path filename = this.createTempFile(((ModuleRequest)request).getArtifactId());
        try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
             CloseableHttpResponse response = client.execute((HttpUriRequest)get);){
            LOG.info("[{} - {}]: Downloaded Metadata for {}.", new Object[]{"DeployArtifactRequest", ((ModuleRequest)request).getId(), ((ModuleRequest)request).getModuleId()});
            response.getEntity().writeTo((OutputStream)new FileOutputStream(filename.toFile()));
            ((ModuleRequest)request).setVersion(this.retrieveAndParseMetadata(filename, (ModuleRequest)request));
        }
        catch (IOException e) {
            LOG.error("[{} - {}]: Error downloading Metadata  -> {}, {}", new Object[]{"DeployArtifactRequest", ((ModuleRequest)request).getId(), e.getMessage(), e});
            throw new IllegalStateException(e);
        }
        return Observable.just(request);
    }

    private Path createTempFile(String filename) {
        return Paths.get(System.getProperty("java.io.tmpdir") + "/" + filename, new String[0]);
    }

    private String retrieveAndParseMetadata(Path fileLocation, ModuleRequest request) {
        Buffer b = this.rxVertx.fileSystem().readFileBlocking(fileLocation.toString());
        return MetadataXPathUtil.getRealSnapshotVersionFromMetadata(b.toString().getBytes(), request);
    }
}

