/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.deploy.agent.handler;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import nl.jpoint.vertx.deploy.agent.request.DeployArtifactRequest;
import nl.jpoint.vertx.deploy.agent.service.DeployArtifactService;
import nl.jpoint.vertx.deploy.agent.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestDeployArtifactHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = LoggerFactory.getLogger(RestDeployArtifactHandler.class);
    private final DeployArtifactService service;

    public RestDeployArtifactHandler(DeployArtifactService service) {
        this.service = service;
    }

    public void handle(RoutingContext context) {
        context.request().bodyHandler(buffer -> {
            String postData = new String(buffer.getBytes());
            DeployArtifactRequest artifactRequest = HttpUtils.readPostData(buffer, DeployArtifactRequest.class, "DeployArtifactRequest");
            if (artifactRequest == null) {
                HttpUtils.respondBadRequest(context.request());
                return;
            }
            LOG.info("[{} - {}]: Received deploy artifact request {}", new Object[]{"DeployArtifactRequest", artifactRequest.getId().toString(), postData});
            this.service.deployAsync(artifactRequest).doOnCompleted(() -> HttpUtils.respondOk(context.request())).doOnError(t -> HttpUtils.respondFailed(context.request()));
        });
    }
}

