/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.deploy.agent.handler;

import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import nl.jpoint.vertx.deploy.agent.request.DeployRequest;
import nl.jpoint.vertx.deploy.agent.request.DeployState;
import nl.jpoint.vertx.deploy.agent.service.AwsService;
import nl.jpoint.vertx.deploy.agent.service.DeployApplicationService;
import nl.jpoint.vertx.deploy.agent.util.ApplicationDeployState;
import nl.jpoint.vertx.deploy.agent.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestDeployStatusHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = LoggerFactory.getLogger(RestDeployStatusHandler.class);
    private final AwsService deployAwsService;
    private final DeployApplicationService deployApplicationService;

    public RestDeployStatusHandler(AwsService deployAwsService, DeployApplicationService deployApplicationService) {
        this.deployAwsService = deployAwsService;
        this.deployApplicationService = deployApplicationService;
    }

    public void handle(RoutingContext context) {
        DeployState state;
        DeployRequest deployRequest = this.deployAwsService.getDeployRequest(context.request().params().get("id"));
        DeployState deployState = state = deployRequest != null ? deployRequest.getState() : DeployState.UNKNOWN;
        if (!this.deployApplicationService.getDeployedApplicationsFailed().isEmpty()) {
            LOG.error("Some services failed to start, failing build");
            state = DeployState.FAILED;
            this.deployAwsService.failAllRunningRequests();
        }
        DeployState deployState2 = state != null ? state : DeployState.CONTINUE;
        LOG.trace("[{}]: Current state : {}", deployRequest != null ? deployRequest.getId() : DeployState.UNKNOWN, (Object)deployState2.name());
        switch (deployState2) {
            case SUCCESS: {
                HttpUtils.respondOk(context.request(), this.createStatusObject(null));
                this.deployApplicationService.cleanup();
                break;
            }
            case UNKNOWN: 
            case FAILED: {
                HttpUtils.respondFailed(context.request(), this.createStatusObject(deployRequest != null ? deployRequest.getFailedReason() : null));
                this.deployApplicationService.cleanup();
                break;
            }
            default: {
                HttpUtils.respondContinue(context.request(), deployState2);
            }
        }
    }

    private JsonObject createStatusObject(String reason) {
        JsonObject result = new JsonObject();
        result.put(ApplicationDeployState.OK.name(), HttpUtils.toArray(this.deployApplicationService.getDeployedApplicationsSuccess()));
        result.put(ApplicationDeployState.ERROR.name(), HttpUtils.toArray(this.deployApplicationService.getDeployedApplicationsFailed()));
        if (reason != null) {
            result.put("Reason", reason);
        }
        return result;
    }
}

