/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.deploy.agent.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nl.jpoint.vertx.deploy.agent.request.ModuleRequest;
import nl.jpoint.vertx.deploy.agent.util.GzipExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ArtifactContextUtil {
    public static final String ARTIFACT_CONTEXT = "artifact_context.xml";
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactContextUtil.class);
    private static final String BASE_LOCATION = "/artifact/baselocation/text()";
    private static final String RESTART_ON_CHANGED_CONTENT = "/artifact/checkContent/text()";
    private static final String RESTART_COMMAND = "/artifact/restartCommand/text()";
    private static final String TEST_COMMAND = "/artifact/testCommand/text()";
    private final XPath xPath = XPathFactory.newInstance().newXPath();
    private Document document;

    public ArtifactContextUtil(ModuleRequest request, Path location) {
        byte[] data;
        if (request.getType().equals("tar.gz")) {
            data = new GzipExtractor<ModuleRequest>(request).readArtifactContext(location);
        } else {
            try (FileSystem zipFs = this.getFileSystem(location.toString());){
                Path path = zipFs.getPath(ARTIFACT_CONTEXT, new String[0]);
                data = Files.readAllBytes(path);
            }
            catch (IOException e) {
                LOG.error("[{} - {}] : No 'artifact_context.xml' in archive. Failing build : {}", new Object[]{"DeployArtifactRequest", request.getId(), e.getMessage()});
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            this.document = builder.parse(new ByteArrayInputStream(data));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error("[{} - {}] : Corrupt 'artifact_context.xml' in archive. Failing build : {}", new Object[]{"DeployArtifactRequest", request.getId(), e.getMessage()});
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public String getBaseLocation() {
        try {
            return this.document != null ? (String)this.xPath.compile(BASE_LOCATION).evaluate(this.document, XPathConstants.STRING) : null;
        }
        catch (XPathExpressionException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean getCheckConfig() {
        try {
            return Boolean.valueOf(this.document != null ? (String)this.xPath.compile(RESTART_ON_CHANGED_CONTENT).evaluate(this.document, XPathConstants.STRING) : null);
        }
        catch (XPathExpressionException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String getRestartCommand() {
        try {
            return this.document != null ? (String)this.xPath.compile(RESTART_COMMAND).evaluate(this.document, XPathConstants.STRING) : null;
        }
        catch (XPathExpressionException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getTestCommand() {
        try {
            return this.document != null ? (String)this.xPath.compile(TEST_COMMAND).evaluate(this.document, XPathConstants.STRING) : null;
        }
        catch (XPathExpressionException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private FileSystem getFileSystem(String location) throws IOException {
        Path path = Paths.get(location, new String[0]);
        URI uri = URI.create("jar:file:" + path.toUri().getPath());
        return FileSystems.newFileSystem(uri, new HashMap());
    }
}

