/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.deploy.agent.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import nl.jpoint.vertx.deploy.agent.command.ExtractArtifact;
import nl.jpoint.vertx.deploy.agent.request.ModuleRequest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GzipExtractor<T extends ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractArtifact.class);
    private final T request;

    public GzipExtractor(T request) {
        this.request = request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] readArtifactContext(Path input) {
        try (InputStream in = Files.newInputStream(this.getDeflatedFile(input), new OpenOption[0]);
             TarArchiveInputStream tarIn = new TarArchiveInputStream(in);){
            ArchiveEntry entry = tarIn.getNextEntry();
            while (entry != null) {
                if ("artifact_context.xml".equals(entry.getName())) {
                    byte[] data = new byte[(int)entry.getSize()];
                    tarIn.read(data, 0, data.length);
                    byte[] byArray = data;
                    return byArray;
                }
                entry = tarIn.getNextEntry();
            }
        }
        catch (IOException e) {
            LOG.warn("[{} - {}]: Error extracting tar  {}.", new Object[]{((ModuleRequest)this.request).getLogName(), ((ModuleRequest)this.request).getId(), e.getMessage()});
            throw new IllegalStateException(e);
        }
        LOG.error("Missing artifact_context.xml in {}", (Object)input);
        throw new IllegalStateException("Missing artifact_context.xml in " + input.toString());
    }

    public void extractTar(Path input, Path output) {
        HashMap<Path, Path> symlinks = new HashMap<Path, Path>();
        try (InputStream in = Files.newInputStream(this.getDeflatedFile(input), new OpenOption[0]);
             TarArchiveInputStream tarIn = new TarArchiveInputStream(in);){
            if (!output.toFile().exists()) {
                Files.createDirectory(output, new FileAttribute[0]);
            }
            TarArchiveEntry entry = (TarArchiveEntry)tarIn.getNextEntry();
            while (entry != null) {
                if (!entry.getName().equals("./")) {
                    if (entry.isSymbolicLink()) {
                        symlinks.put(output.resolve(entry.getName()).toAbsolutePath(), output.resolve(entry.getName()).getParent().resolve(entry.getLinkName()));
                    } else if (entry.isDirectory()) {
                        Files.createDirectory(output.resolve(entry.getName()), new FileAttribute[0]);
                    } else if (!"artifact_context.xml".equals(entry.getName())) {
                        byte[] contents = new byte[(int)entry.getSize()];
                        tarIn.read(contents, 0, contents.length);
                        Files.write(output.resolve(entry.getName()), contents, new OpenOption[0]);
                    }
                }
                entry = (TarArchiveEntry)tarIn.getNextEntry();
            }
            symlinks.forEach(this::createSymlink);
            Files.delete(this.getDeflatedFile(input));
        }
        catch (IOException e) {
            LOG.warn("[{} - {}]: Error extracting tar  {}.", new Object[]{((ModuleRequest)this.request).getLogName(), ((ModuleRequest)this.request).getId(), e.getMessage()});
            throw new IllegalStateException(e);
        }
    }

    public void deflateGz(Path input) {
        File tempFile = new File(this.getDeflatedFile(input).toUri());
        try (InputStream fin = Files.newInputStream(input, new OpenOption[0]);
             BufferedInputStream in = new BufferedInputStream(fin);
             GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)in);
             FileOutputStream out = new FileOutputStream(tempFile);){
            int n;
            byte[] buffer = new byte[4096];
            while (-1 != (n = gzIn.read(buffer))) {
                out.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            LOG.warn("[{} - {}]: Error extracting gzip  {}.", new Object[]{((ModuleRequest)this.request).getLogName(), ((ModuleRequest)this.request).getId(), e.getMessage()});
            throw new IllegalStateException(e);
        }
    }

    private Path getDeflatedFile(Path input) {
        return input.getParent().resolve(StringUtils.substringBeforeLast((String)input.getFileName().toString(), (String)".gz"));
    }

    private void createSymlink(Path link, Path target) {
        try {
            LOG.trace("Creating symbolic link {} -> {}", (Object)link, (Object)target);
            Files.createSymbolicLink(link, target.toRealPath(new LinkOption[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.warn("[{} - {}]: Error extracting tar  {}.", new Object[]{((ModuleRequest)this.request).getLogName(), ((ModuleRequest)this.request).getId(), e.getMessage()});
            throw new IllegalStateException(e);
        }
    }
}

