/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.deploy.agent;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.web.Router;
import nl.jpoint.vertx.deploy.agent.DeployConfig;
import nl.jpoint.vertx.deploy.agent.handler.RestDeployArtifactHandler;
import nl.jpoint.vertx.deploy.agent.handler.RestDeployHandler;
import nl.jpoint.vertx.deploy.agent.handler.RestDeployModuleHandler;
import nl.jpoint.vertx.deploy.agent.handler.RestDeployStatusHandler;
import nl.jpoint.vertx.deploy.agent.handler.StatusUpdateHandler;
import nl.jpoint.vertx.deploy.agent.service.AutoDiscoverDeployService;
import nl.jpoint.vertx.deploy.agent.service.AwsService;
import nl.jpoint.vertx.deploy.agent.service.DefaultDeployService;
import nl.jpoint.vertx.deploy.agent.service.DeployApplicationService;
import nl.jpoint.vertx.deploy.agent.service.DeployArtifactService;
import nl.jpoint.vertx.deploy.agent.service.DeployConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AwsDeployApplication
extends AbstractVerticle {
    private static final Logger LOG = LoggerFactory.getLogger(AwsDeployApplication.class);
    private boolean initiated = false;

    public void start() {
        MDC.put((String)"service", (String)"deploy");
        DeployConfig deployconfig = DeployConfig.fromJsonObject(this.config());
        if (this.config() == null) {
            LOG.error("Unable to read config file");
            throw new IllegalStateException("Unable to read config file");
        }
        DeployApplicationService deployApplicationService = new DeployApplicationService(deployconfig, this.getVertx());
        DeployArtifactService deployArtifactService = new DeployArtifactService(this.getVertx(), deployconfig);
        DeployConfigService deployConfigService = new DeployConfigService(this.getVertx(), deployconfig);
        DefaultDeployService defaultDeployService = new DefaultDeployService(deployApplicationService, deployArtifactService, deployConfigService);
        this.createRunDir(deployconfig);
        deployApplicationService.cleanup().subscribe();
        AwsService awsService = null;
        AutoDiscoverDeployService autoDiscoverDeployService = null;
        if (deployconfig.isAwsEnabled()) {
            awsService = new AwsService(this.getVertx(), deployconfig);
            autoDiscoverDeployService = new AutoDiscoverDeployService(deployconfig, defaultDeployService, this.getVertx());
        }
        Router router = Router.router((Vertx)this.getVertx());
        router.post("/deploy/deploy").handler((Handler)new RestDeployHandler(defaultDeployService, awsService, deployconfig.getAuthToken()));
        router.post("/deploy/module*").handler((Handler)new RestDeployModuleHandler(deployApplicationService));
        router.post("/deploy/artifact*").handler((Handler)new RestDeployArtifactHandler(deployArtifactService));
        router.get("/deploy/update*").handler((Handler)new StatusUpdateHandler(deployApplicationService));
        if (deployconfig.isAwsEnabled()) {
            router.get("/deploy/status/:id").handler((Handler)new RestDeployStatusHandler(awsService, deployApplicationService));
        }
        router.get("/status").handler(event -> {
            if (this.initiated) {
                event.response().setStatusCode(HttpResponseStatus.FORBIDDEN.code());
            } else {
                event.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
            }
            event.response().end();
            event.response().close();
        });
        HttpServer server = this.vertx.createHttpServer().requestHandler(arg_0 -> ((Router)router).accept(arg_0));
        server.listen(deployconfig.getHttpPort().intValue());
        this.initiated = true;
        LOG.info("{}: Instantiated module.", (Object)"ClusterManager");
        if (deployconfig.isAwsEnabled() && deployconfig.isAwsAutoDiscover() && autoDiscoverDeployService != null) {
            autoDiscoverDeployService.autoDiscoverFirstDeploy();
        }
    }

    private void createRunDir(DeployConfig deployconfig) {
        if (!this.vertx.fileSystem().existsBlocking(deployconfig.getRunDir())) {
            LOG.debug("Creating runDir '{}'.", (Object)deployconfig.getRunDir());
            this.vertx.fileSystem().mkdirBlocking(deployconfig.getRunDir());
        }
    }

    public void stop() {
        LOG.warn("Stopping deploy application");
    }
}

