/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.deploy.agent.aws.state;

import io.vertx.core.Vertx;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import nl.jpoint.vertx.deploy.agent.aws.AwsElbUtil;
import nl.jpoint.vertx.deploy.agent.aws.AwsState;
import nl.jpoint.vertx.deploy.agent.request.DeployRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

class AwsPollingElbStateObservable {
    private static final Logger LOG = LoggerFactory.getLogger(AwsPollingElbStateObservable.class);
    private static final Long POLLING_INTERVAL_IN_MS = 3000L;
    private final io.vertx.rxjava.core.Vertx rxVertx;
    private final AwsElbUtil awsElbUtil;
    private final LocalDateTime timeout;
    private final List<AwsState> acceptedStates;
    private final String deployId;
    private final Function<String, Boolean> requestStillActive;

    public AwsPollingElbStateObservable(Vertx vertx, String deployId, AwsElbUtil awsElbUtil, LocalDateTime timeout, Function<String, Boolean> requestStillActive, AwsState ... acceptedStates) {
        this.deployId = deployId;
        this.requestStillActive = requestStillActive;
        this.rxVertx = new io.vertx.rxjava.core.Vertx(vertx);
        this.awsElbUtil = awsElbUtil;
        this.timeout = timeout;
        this.acceptedStates = Arrays.asList(acceptedStates);
    }

    public Observable<DeployRequest> poll(DeployRequest request, String elb) {
        LOG.info("[{} - {}]: Starting instance status poller for instance id {} on loadbalancer {}", new Object[]{"ConfigureAwsElb", request.getId(), this.awsElbUtil.getInstanceId(), elb});
        return this.doPoll(request, elb);
    }

    private Observable<DeployRequest> doPoll(DeployRequest request, String elb) {
        return this.rxVertx.timerStream(POLLING_INTERVAL_IN_MS.longValue()).toObservable().flatMap(x -> this.awsElbUtil.pollForInstanceState(elb)).flatMap(awsState -> {
            if (!this.requestStillActive.apply(this.deployId).booleanValue()) {
                LOG.error("[{} - {}]: Request canceled, stopping poller {} ", new Object[]{"ConfigureAwsElb", request.getId(), awsState.name()});
                throw new IllegalStateException();
            }
            if (LocalDateTime.now().isAfter(this.timeout)) {
                LOG.error("[{} - {}]: Timeout while waiting for instance to reach {} ", new Object[]{"ConfigureAwsElb", request.getId(), awsState.name()});
                throw new IllegalStateException();
            }
            LOG.info("[{} - {}]: Instance {} on elb {} in state {}", new Object[]{"ConfigureAwsElb", request.getId(), this.awsElbUtil.getInstanceId(), elb, awsState.name()});
            if (this.acceptedStates.contains(awsState)) {
                return Observable.just((Object)request);
            }
            return this.doPoll(request, elb);
        });
    }
}

