/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.deploy.agent.service;

import io.vertx.core.Vertx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.jpoint.vertx.deploy.agent.DeployConfig;
import nl.jpoint.vertx.deploy.agent.aws.AwsAutoScalingUtil;
import nl.jpoint.vertx.deploy.agent.request.DeployApplicationRequest;
import nl.jpoint.vertx.deploy.agent.request.DeployArtifactRequest;
import nl.jpoint.vertx.deploy.agent.request.DeployConfigRequest;
import nl.jpoint.vertx.deploy.agent.request.DeployRequest;
import nl.jpoint.vertx.deploy.agent.service.DefaultDeployService;
import nl.jpoint.vertx.deploy.agent.util.AetherUtil;
import nl.jpoint.vertx.deploy.agent.util.DeployType;
import org.apache.maven.model.Model;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class AutoDiscoverDeployService {
    private static final Logger LOG = LoggerFactory.getLogger(AutoDiscoverDeployService.class);
    private final DeployConfig deployConfig;
    private final AwsAutoScalingUtil awsAutoScalingUtil;
    private final DefaultDeployService defaultDeployService;
    private final RepositorySystem system;
    private final RepositorySystemSession session;
    private final Vertx vertx;

    public AutoDiscoverDeployService(DeployConfig config, DefaultDeployService defaultDeployService, Vertx vertx) {
        this.deployConfig = config;
        this.awsAutoScalingUtil = new AwsAutoScalingUtil(config);
        this.defaultDeployService = defaultDeployService;
        this.vertx = vertx;
        this.system = AetherUtil.newRepositorySystem();
        this.session = AetherUtil.newRepositorySystemSession(this.system);
    }

    public void autoDiscoverFirstDeploy() {
        boolean testScope;
        if (this.vertx.fileSystem().existsBlocking(this.deployConfig.getStatFile())) {
            LOG.info("Not initial run, skipping auto discover deploy");
            return;
        }
        Map<String, String> tags = this.awsAutoScalingUtil.getDeployTags();
        ArrayList<Artifact> dependencies = new ArrayList<Artifact>();
        if (this.deployConfig.isTypedDeploy()) {
            testScope = Boolean.parseBoolean(tags.getOrDefault(DeployType.APPLICATION.getScopeTag(), "false")) || Boolean.parseBoolean(tags.getOrDefault(DeployType.ARTIFACT.getScopeTag(), "false"));
            dependencies.addAll(this.getDependenciesForDeployType(tags, DeployType.APPLICATION, testScope));
            dependencies.addAll(this.getDependenciesForDeployType(tags, DeployType.ARTIFACT, testScope));
        } else {
            testScope = Boolean.parseBoolean(tags.getOrDefault(DeployType.DEFAULT.getScopeTag(), "false"));
            dependencies.addAll(this.getDependenciesForDeployType(tags, DeployType.DEFAULT, testScope));
        }
        if (!dependencies.isEmpty()) {
            DeployRequest request = this.createAutoDiscoverDeployRequest(dependencies, testScope);
            LOG.info("[{}] : Starting auto discover deploy ", (Object)request.getId());
            Observable.just((Object)request).flatMap(x -> this.defaultDeployService.deployConfigs(request.getId(), request.getConfigs())).flatMap(x -> this.defaultDeployService.deployArtifacts(request.getId(), request.getArtifacts())).flatMap(x -> this.defaultDeployService.deployApplications(request.getId(), request.getModules())).doOnError(t -> LOG.error("[{}] : Error while performing auto discover deploy {}", (Object)request.getId(), t)).doOnCompleted(() -> {
                LOG.info("[{}] : Completed auto discover deploy.", (Object)request.getId());
                this.vertx.fileSystem().createFileBlocking(this.deployConfig.getStatFile());
            }).subscribe();
        }
    }

    private List<Artifact> getDependenciesForDeployType(Map<String, String> tags, DeployType type, boolean testScope) {
        if (!tags.containsKey(type.getLatestRequestTag()) || tags.get(type.getLatestRequestTag()) == null || tags.get(type.getLatestRequestTag()).isEmpty()) {
            LOG.info("No tag {} in auto scaling group.", (Object)type.getLatestRequestTag());
            return new ArrayList<Artifact>();
        }
        Artifact deployArtifact = this.getDeployArtifact(tags.get(type.getLatestRequestTag()));
        ArrayList<Artifact> dependencies = new ArrayList<Artifact>();
        if (deployArtifact != null) {
            dependencies.addAll(this.getDeployDependencies(deployArtifact, this.getExclusions(tags.getOrDefault(type.getExclusionTag(), "")), testScope, this.getProperties(tags.getOrDefault(type.getPropertiesTag(), "")), type));
            dependencies.forEach(a -> LOG.trace("{}:{}:{}:{}", new Object[]{a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getVersion()}));
        }
        return dependencies;
    }

    private DeployRequest createAutoDiscoverDeployRequest(List<Artifact> dependencies, boolean testScope) {
        List<DeployConfigRequest> configs = dependencies.stream().filter(a -> "config".equals(a.getExtension())).map(a -> DeployConfigRequest.build(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getClassifier())).collect(Collectors.toList());
        List<DeployArtifactRequest> artifacts = dependencies.stream().filter(a -> "zip".equals(a.getExtension()) || "tar.gz".equals(a.getExtension())).map(a -> DeployArtifactRequest.build(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getClassifier(), a.getExtension())).collect(Collectors.toList());
        List<DeployApplicationRequest> applications = dependencies.stream().filter(a -> "jar".equals(a.getExtension())).map(a -> DeployApplicationRequest.build(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getClassifier(), testScope)).collect(Collectors.toList());
        return new DeployRequest(applications, artifacts, configs, false, false, "", false, testScope);
    }

    private Artifact getDeployArtifact(String mavenCoords) {
        DefaultArtifact artifact = new DefaultArtifact(mavenCoords);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)artifact);
        artifactRequest.setRepositories(AetherUtil.newRepositories(this.deployConfig));
        try {
            ArtifactResult artifactResult = this.system.resolveArtifact(this.session, artifactRequest);
            return artifactResult.getArtifact();
        }
        catch (ArtifactResolutionException e) {
            LOG.error("Unable to resolve deploy artifact '{}', unable to auto-discover ", (Object)mavenCoords, (Object)e);
            return null;
        }
    }

    private List<Artifact> getDeployDependencies(Artifact artifact, List<Exclusion> exclusions, boolean testScope, Map<String, String> properties, DeployType type) {
        ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
        descriptorRequest.setRepositories(AetherUtil.newRepositories(this.deployConfig));
        descriptorRequest.setArtifact(artifact);
        Model model = AetherUtil.readPom(artifact);
        if (model == null) {
            throw new IllegalStateException("Unable to read POM for " + artifact.getFile());
        }
        try {
            ArtifactDescriptorResult descriptorResult = this.system.readArtifactDescriptor(this.session, descriptorRequest);
            return descriptorResult.getDependencies().stream().filter(d -> type == DeployType.DEFAULT || type == DeployType.APPLICATION && !d.getArtifact().getExtension().equals("zip") || type == DeployType.ARTIFACT && !d.getArtifact().getExtension().equals("jar")).filter(d -> "compile".equalsIgnoreCase(d.getScope()) || "test".equalsIgnoreCase(d.getScope()) && testScope).filter(d -> !exclusions.contains(new Exclusion(d.getArtifact().getGroupId(), d.getArtifact().getArtifactId(), null, null))).map(Dependency::getArtifact).map(d -> this.checkWithModel(model, (Artifact)d, properties)).collect(Collectors.toList());
        }
        catch (ArtifactDescriptorException e) {
            LOG.error("Unable to resolve dependencies for deploy artifact '{}', unable to auto-discover ", (Object)artifact, (Object)e);
            return Collections.emptyList();
        }
    }

    private Artifact checkWithModel(Model model, Artifact artifact, Map<String, String> properties) {
        Optional<org.apache.maven.model.Dependency> result = model.getDependencies().stream().filter(d -> d.getGroupId().equals(artifact.getGroupId())).filter(d -> d.getArtifactId().equals(artifact.getArtifactId())).filter(d -> d.getClassifier() != null && properties.containsKey(d.getClassifier().substring(2, d.getClassifier().length() - 1))).findFirst();
        return result.isPresent() ? new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), properties.get(result.get().getClassifier().substring(2, result.get().getClassifier().length() - 1)), artifact.getExtension(), artifact.getVersion(), artifact.getProperties(), artifact.getFile()) : artifact;
    }

    private List<Exclusion> getExclusions(String exclusionString) {
        if (exclusionString == null || exclusionString.isEmpty()) {
            return Collections.emptyList();
        }
        return Stream.of(exclusionString.split(";")).map(this::toExclusion).collect(Collectors.toList());
    }

    private Map<String, String> getProperties(String propertiesString) {
        if (propertiesString == null || propertiesString.isEmpty()) {
            return Collections.emptyMap();
        }
        return Stream.of(propertiesString.split(";")).filter(s -> s.contains(":")).map(s -> s.split(":")).filter(s -> ((String[])s).length == 2).collect(Collectors.toMap(strings -> strings[0], strings -> strings[1]));
    }

    private Exclusion toExclusion(String s) {
        String[] ex = s.split(":", 2);
        return new Exclusion(ex[0], ex[1], null, null);
    }
}

