/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.deploy.agent.util;

import io.vertx.rxjava.core.Vertx;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import nl.jpoint.vertx.deploy.agent.request.ModuleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Emitter;
import rx.Observable;

public class ObservableCommand<R extends ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ObservableCommand.class);
    private static final Long POLLING_INTERVAL_IN_MS = 500L;
    private final Integer expectedResultCode;
    private final Vertx rxVertx;
    private final R request;
    private Process process;

    public ObservableCommand(R request, Integer expectedResultCode, Vertx vertx) {
        this.request = request;
        this.expectedResultCode = expectedResultCode;
        this.rxVertx = vertx;
    }

    public Observable<Integer> execute(ProcessBuilder builder) {
        return this.observableCommand(builder).flatMap(x -> this.waitForExit()).flatMap(x -> {
            if (this.process.exitValue() != this.expectedResultCode.intValue()) {
                throw new IllegalStateException("Error executing process");
            }
            return Observable.just((Object)x);
        });
    }

    private Observable<Integer> waitForExit() {
        return this.rxVertx.timerStream(POLLING_INTERVAL_IN_MS.longValue()).toObservable().flatMap(x -> {
            if (this.process.isAlive()) {
                return this.waitForExit();
            }
            if (this.process.exitValue() != this.expectedResultCode.intValue()) {
                this.printStream(this.process.getInputStream(), false);
                throw new IllegalStateException(this.printStream(this.process.getErrorStream(), true));
            }
            this.printStream(this.process.getInputStream(), false);
            return Observable.just((Object)this.process.exitValue());
        });
    }

    private Observable<String> observableCommand(ProcessBuilder builder) {
        return Observable.create(subscriber -> {
            this.process = null;
            try {
                builder.directory(new File(System.getProperty("java.io.tmpdir")));
                this.process = builder.start();
            }
            catch (IOException e) {
                subscriber.onError((Throwable)e);
            }
            subscriber.onNext((Object)"Done");
            subscriber.onCompleted();
        }, (Emitter.BackpressureMode)Emitter.BackpressureMode.NONE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String printStream(InputStream stream, boolean error) {
        if (stream == null) {
            return null;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (error) {
                    LOG.error("[{} - {}]: Command output -> '{}'", new Object[]{"ConsoleCommand", ((ModuleRequest)this.request).getId(), line});
                    continue;
                }
                LOG.info("[{} - {}]: Command output -> '{}'", new Object[]{"ConsoleCommand", ((ModuleRequest)this.request).getId(), line});
            }
            String string = line;
            return string;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }
}

