/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.deploy.agent.aws.state;

import io.vertx.core.Vertx;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import nl.jpoint.vertx.deploy.agent.aws.AwsAutoScalingUtil;
import nl.jpoint.vertx.deploy.agent.aws.AwsState;
import nl.jpoint.vertx.deploy.agent.request.DeployRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

class AwsPollingAsStateObservable {
    private static final Logger LOG = LoggerFactory.getLogger(AwsPollingAsStateObservable.class);
    private final io.vertx.rxjava.core.Vertx rxVertx;
    private final AwsAutoScalingUtil awsAsUtil;
    private final LocalDateTime timeout;
    private final long pollInterval;
    private final List<AwsState> acceptedStates;

    public AwsPollingAsStateObservable(Vertx vertx, AwsAutoScalingUtil awsAsUtil, LocalDateTime timeout, long pollInterval, AwsState ... acceptedStates) {
        this.rxVertx = new io.vertx.rxjava.core.Vertx(vertx);
        this.awsAsUtil = awsAsUtil;
        this.timeout = timeout;
        this.pollInterval = pollInterval;
        this.acceptedStates = Arrays.asList(acceptedStates);
    }

    public Observable<DeployRequest> poll(DeployRequest request) {
        LOG.info("[{} - {}]: Setting timeout to {}.", new Object[]{"ConfigureAwsAutoScaling", request.getId(), this.timeout});
        return this.doPoll(request);
    }

    private Observable<DeployRequest> doPoll(DeployRequest request) {
        return this.rxVertx.timerStream(this.pollInterval).toObservable().flatMap(x -> this.awsAsUtil.pollForInstanceState()).flatMap(awsState -> {
            if (LocalDateTime.now().isAfter(this.timeout)) {
                LOG.error("[{} - {}]: Timeout while waiting for instance to reach {} ", new Object[]{"ConfigureAwsAutoScaling", request.getId(), awsState.name()});
                throw new IllegalStateException();
            }
            LOG.info("[{} - {}]: Instance {} in auto scaling group {} in state {}", new Object[]{"ConfigureAwsAutoScaling", request.getId(), this.awsAsUtil.getInstanceId(), request.getAutoScalingGroup(), awsState.name()});
            if (this.acceptedStates.contains(awsState)) {
                return Observable.just((Object)request);
            }
            return this.doPoll(request);
        });
    }
}

