/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.deploy.agent.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import nl.jpoint.vertx.deploy.agent.request.DeployApplicationRequest;
import nl.jpoint.vertx.deploy.agent.request.DeployArtifactRequest;
import nl.jpoint.vertx.deploy.agent.request.DeployConfigRequest;
import nl.jpoint.vertx.deploy.agent.request.DeployState;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeployRequest {
    private final UUID id = UUID.randomUUID();
    private final List<DeployApplicationRequest> modules;
    private final List<DeployConfigRequest> configs;
    private final List<DeployArtifactRequest> artifacts;
    private final boolean elb;
    private final boolean autoScaling;
    private final String autoScalingGroup;
    private boolean decrementDesiredCapacity = true;
    private boolean restart;
    private DeployState state;
    private long timestamp;
    private final boolean testScope;
    private String failedReason;

    @JsonCreator
    public DeployRequest(@JsonProperty(value="modules") List<DeployApplicationRequest> modules, @JsonProperty(value="artifacts") List<DeployArtifactRequest> artifacts, @JsonProperty(value="configs") List<DeployConfigRequest> configs, @JsonProperty(value="with_elb") boolean elb, @JsonProperty(value="with_as") boolean autoScaling, @JsonProperty(value="as_group_id") String autoScalingGroup, @JsonProperty(value="restart") boolean restart, @JsonProperty(value="test_scope") boolean testScope) {
        this.modules = modules != null ? modules : Collections.emptyList();
        this.artifacts = artifacts != null ? artifacts : Collections.emptyList();
        this.configs = configs != null ? configs : Collections.emptyList();
        this.testScope = testScope;
        this.elb = elb;
        this.autoScaling = autoScaling;
        this.autoScalingGroup = autoScalingGroup;
        this.restart = restart;
    }

    public List<DeployArtifactRequest> getArtifacts() {
        return this.artifacts;
    }

    public List<DeployApplicationRequest> getModules() {
        return this.modules;
    }

    public List<DeployConfigRequest> getConfigs() {
        return this.configs;
    }

    public UUID getId() {
        return this.id;
    }

    public String getAutoScalingGroup() {
        return this.autoScalingGroup;
    }

    public boolean withElb() {
        return this.elb;
    }

    public boolean withAutoScaling() {
        return this.elb && this.autoScaling;
    }

    public boolean withRestart() {
        return this.restart;
    }

    public DeployState getState() {
        return this.state;
    }

    public void setState(DeployState state) {
        this.state = state;
    }

    public boolean isDecrementDesiredCapacity() {
        return this.decrementDesiredCapacity;
    }

    public boolean isScopeTest() {
        return this.testScope;
    }

    @JsonProperty(value="as_decrement_desired_capacity")
    public void setDecrementDesiredCapacity(boolean decrementDesiredCapacity) {
        this.decrementDesiredCapacity = decrementDesiredCapacity;
    }

    public void setRestart(boolean restart) {
        this.restart = restart;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setFailedReason(String reason) {
        this.failedReason = reason;
    }

    public String getFailedReason() {
        return this.failedReason;
    }
}

