/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.deploy.agent.command;

import io.vertx.core.Vertx;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import nl.jpoint.vertx.deploy.agent.DeployConfig;
import nl.jpoint.vertx.deploy.agent.command.Command;
import nl.jpoint.vertx.deploy.agent.request.ModuleRequest;
import nl.jpoint.vertx.deploy.agent.util.FileDigestUtil;
import nl.jpoint.vertx.deploy.agent.util.GzipExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class ExtractArtifact<T extends ModuleRequest>
implements Command<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractArtifact.class);
    private final io.vertx.rxjava.core.Vertx vertx;
    private final DeployConfig config;
    private final Path basePath;
    private final FileDigestUtil fileDigestUtil;

    public ExtractArtifact(Vertx vertx, DeployConfig config, Path basePath) {
        this.vertx = new io.vertx.rxjava.core.Vertx(vertx);
        this.config = config;
        this.basePath = basePath;
        this.fileDigestUtil = new FileDigestUtil();
    }

    @Override
    public Observable<T> executeAsync(T request) {
        switch (((ModuleRequest)request).getType()) {
            case "config": 
            case "zip": {
                return this.extractZip(request);
            }
            case "tar.gz": {
                return this.extractGZip(request);
            }
        }
        LOG.error("Unsupported artifact type : " + ((ModuleRequest)request).getType());
        throw new IllegalStateException();
    }

    private Observable<T> extractZip(T request) {
        Observable observable;
        block9: {
            FileSystem zipFs = this.getFileSystem(((ModuleRequest)request).getLocalPath(this.config.getArtifactRepo()));
            try {
                LOG.info("[{} - {}]: Extracting artifact {} to {}.", new Object[]{((ModuleRequest)request).getLogName(), ((ModuleRequest)request).getId(), ((ModuleRequest)request).getModuleId(), this.basePath});
                if (((ModuleRequest)request).deleteBase()) {
                    this.removeBasePath((ModuleRequest)request, this.basePath);
                }
                Path zipRoot = zipFs.getPath("/", new String[0]);
                Files.walkFileTree(zipRoot, this.copyingFileVisitor(this.basePath, request));
                LOG.info("[{} - {}]: Extracted artifact {} to {}.", new Object[]{((ModuleRequest)request).getLogName(), ((ModuleRequest)request).getId(), ((ModuleRequest)request).getModuleId(), this.basePath});
                observable = Observable.just(request).doOnError(t -> LOG.error("Unable to extract artifact {}, {}", (Object)t.getMessage(), t));
                if (zipFs == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFs != null) {
                        try {
                            zipFs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InvalidPathException e) {
                    LOG.error("[{} - {}]: Error while extracting artifact {} -> {}.", new Object[]{((ModuleRequest)request).getLogName(), ((ModuleRequest)request).getId(), ((ModuleRequest)request).getModuleId(), e.getMessage(), e});
                    throw new IllegalStateException();
                }
            }
            zipFs.close();
        }
        return observable;
    }

    private Observable<T> extractGZip(T request) {
        GzipExtractor<T> gzipExtractor = new GzipExtractor<T>(request);
        if (((ModuleRequest)request).deleteBase()) {
            this.removeBasePath((ModuleRequest)request, this.basePath);
        }
        gzipExtractor.extractTar(((ModuleRequest)request).getLocalPath(this.config.getArtifactRepo()), this.basePath);
        return Observable.just(request);
    }

    private SimpleFileVisitor<Path> copyingFileVisitor(final Path basePath, final T request) {
        return new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                byte[] oldDigest = null;
                byte[] newDigest = null;
                if ("artifact_context.xml".equals(file.getFileName().toString())) {
                    return FileVisitResult.CONTINUE;
                }
                Path unpackFile = Paths.get(basePath.toString(), file.toString());
                if (request.checkConfig()) {
                    oldDigest = ExtractArtifact.this.fileDigestUtil.getFileMd5Sum(unpackFile);
                }
                Files.copy(file, unpackFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                if (request.checkConfig()) {
                    newDigest = ExtractArtifact.this.fileDigestUtil.getFileMd5Sum(unpackFile);
                }
                if (!request.restart() && request.checkConfig() && !Arrays.equals(oldDigest, newDigest)) {
                    LOG.warn("[{} - {}]: Config changed, forcing container restart if necessary.", new Object[]{request.getLogName(), request.getId(), request.getModuleId()});
                    request.setRestart(true);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attributes) throws IOException {
                Path subDir = Paths.get(basePath.toString(), dir.toString());
                if (!subDir.toFile().exists()) {
                    Files.createDirectory(subDir, new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }
        };
    }

    private void removeBasePath(ModuleRequest request, Path basePath) {
        if (!basePath.getParent().toFile().exists() || !basePath.getParent().toFile().canWrite()) {
            LOG.warn("[{} - {}]: Unable to extract artifact {} -> {} not exist or not writable.", new Object[]{request.getLogName(), request.getId(), request.getModuleId(), basePath.getParent()});
            LOG.warn("[{} - {}]: Unable to extract artifact {} to basePath -> {}.", new Object[]{request.getLogName(), request.getId(), request.getModuleId(), basePath.getParent().toFile()});
        }
        if (basePath.toFile().exists()) {
            LOG.info("[{} - {}]: Removing base path -> {}.", new Object[]{request.getLogName(), request.getId(), basePath.toAbsolutePath()});
            this.vertx.fileSystem().deleteRecursiveBlocking(basePath.toString(), true);
        }
    }

    private FileSystem getFileSystem(Path location) throws IOException {
        URI uri = URI.create("jar:file:" + location.toUri().getPath());
        return FileSystems.newFileSystem(uri, new HashMap());
    }
}

