/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.maven.vertx.mojo;

import java.util.List;
import nl.jpoint.maven.vertx.mojo.DeployConfiguration;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

abstract class AbstractDeployMojo
extends AbstractMojo {
    static final String SITE_CLASSIFIER = "site";
    static final String MODULE_CLASSIFIER = "mod";
    DeployConfiguration activeConfiguration;
    @Component
    MavenProject project;
    @Component
    Settings settings;
    @Parameter
    private List<DeployConfiguration> deployConfigurations;
    @Parameter(defaultValue="default", property="deploy.activeTarget")
    private String activeTarget;
    @Parameter(defaultValue="false", property="deploy.testScope")
    protected Boolean testScope;

    AbstractDeployMojo() {
    }

    DeployConfiguration setActiveDeployConfig() throws MojoFailureException {
        if (this.deployConfigurations.size() == 1) {
            this.getLog().info((CharSequence)"Found exactly one deploy config to activate.");
            this.activeConfiguration = this.deployConfigurations.get(0);
        } else {
            for (DeployConfiguration config : this.deployConfigurations) {
                if (!this.activeTarget.equals(config.getTarget())) continue;
                this.activeConfiguration = config;
                break;
            }
        }
        if (this.activeConfiguration == null) {
            this.getLog().error((CharSequence)"No active deployConfig !");
            throw new MojoFailureException("No active deployConfig !, config should contain at least one config with scope default");
        }
        this.getLog().info((CharSequence)("Deploy config with target " + this.activeConfiguration.getTarget() + " activated"));
        return this.activeConfiguration;
    }
}

